/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.server.client.branch;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBranch;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class BitbucketServerBranch
implements BitbucketBranch {
    private static final Logger LOGGER = Logger.getLogger(BitbucketServerBranch.class.getName());
    private String displayId;
    private String latestCommit;
    private String message;
    private String author;
    private Long timestamp;
    private Callable<BitbucketCommit> commitClosure;
    private boolean callableInitialised = false;

    public BitbucketServerBranch() {
    }

    public BitbucketServerBranch(String name, String headHash) {
        this.displayId = name;
        this.latestCommit = headHash;
    }

    @Override
    public String getRawNode() {
        return this.latestCommit;
    }

    @Override
    public String getName() {
        return this.displayId;
    }

    public synchronized long getTimestamp() {
        return this.timestamp();
    }

    @Override
    public long getDateMillis() {
        return this.timestamp();
    }

    public void setDisplayId(String displayId) {
        this.displayId = displayId;
    }

    public void setLatestCommit(String latestCommit) {
        this.latestCommit = latestCommit;
    }

    public void setName(String displayId) {
        this.displayId = displayId;
    }

    public void setRawNode(String latestCommit) {
        this.latestCommit = latestCommit;
    }

    public synchronized void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized void setCommitClosure(Callable<BitbucketCommit> commitClosure) {
        this.commitClosure = commitClosure;
    }

    private synchronized long timestamp() {
        if (this.timestamp == null) {
            if (this.commitClosure == null) {
                this.timestamp = 0L;
            } else {
                this.initHeadCommitInfo();
            }
        }
        return this.timestamp == null ? 0L : this.timestamp;
    }

    @Override
    public String getMessage() {
        if (this.message == null) {
            this.initHeadCommitInfo();
        }
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getAuthor() {
        if (this.author == null) {
            this.initHeadCommitInfo();
        }
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    private synchronized void initHeadCommitInfo() {
        if (this.callableInitialised || this.commitClosure == null) {
            return;
        }
        try {
            BitbucketCommit commit = this.commitClosure.call();
            this.timestamp = commit.getDateMillis();
            this.message = commit.getMessage();
            this.author = commit.getAuthor();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Could not determine head commit details", e);
            this.timestamp = 0L;
            this.message = "Unknown";
            this.author = "Unknown";
        }
        this.callableInitialised = true;
    }
}

