/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.endpoints;

import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpointDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.server.BitbucketServerVersion;
import com.cloudbees.jenkins.plugins.bitbucket.server.BitbucketServerWebhookImplementation;
import com.damnhandy.uri.template.UriTemplate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.ModelObject;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import jenkins.scm.api.SCMName;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class BitbucketServerEndpoint
extends AbstractBitbucketEndpoint {
    private static final String[] COMMON_PREFIX_HOSTNAMES = new String[]{"git.", "bitbucket.", "bb.", "stash.", "vcs.", "scm.", "source."};
    @CheckForNull
    private final String displayName;
    @NonNull
    private final String serverUrl;
    @NonNull
    private BitbucketServerWebhookImplementation webhookImplementation = BitbucketServerWebhookImplementation.PLUGIN;
    private BitbucketServerVersion serverVersion = BitbucketServerVersion.VERSION_7;
    private boolean callCanMerge = true;
    private boolean callChanges = true;

    @DataBoundConstructor
    public BitbucketServerEndpoint(@CheckForNull String displayName, @NonNull String serverUrl, boolean manageHooks, @CheckForNull String credentialsId) {
        super(manageHooks, credentialsId);
        this.serverUrl = BitbucketEndpointConfiguration.normalizeServerUrl(serverUrl);
        this.displayName = StringUtils.isBlank((String)displayName) ? SCMName.fromUrl((String)this.serverUrl, (String[])COMMON_PREFIX_HOSTNAMES) : displayName.trim();
    }

    @Restricted(value={NoExternalUse.class})
    public BitbucketServerEndpoint(@CheckForNull String displayName, @NonNull String serverUrl, boolean manageHooks, @CheckForNull String credentialsId, String endpointUrl) {
        this(displayName, serverUrl, manageHooks, credentialsId);
        this.setBitbucketJenkinsRootUrl(endpointUrl);
    }

    @NonNull
    public static BitbucketServerWebhookImplementation findWebhookImplementation(String serverUrl) {
        AbstractBitbucketEndpoint endpoint = BitbucketEndpointConfiguration.get().findEndpoint(serverUrl);
        if (endpoint instanceof BitbucketServerEndpoint) {
            return ((BitbucketServerEndpoint)endpoint).getWebhookImplementation();
        }
        return BitbucketServerWebhookImplementation.PLUGIN;
    }

    public boolean isCallCanMerge() {
        return this.callCanMerge;
    }

    @DataBoundSetter
    public void setCallCanMerge(boolean callCanMerge) {
        this.callCanMerge = callCanMerge;
    }

    public boolean isCallChanges() {
        return this.callChanges;
    }

    @DataBoundSetter
    public void setCallChanges(boolean callChanges) {
        this.callChanges = callChanges;
    }

    @NonNull
    public static BitbucketServerVersion findServerVersion(String serverUrl) {
        AbstractBitbucketEndpoint endpoint = BitbucketEndpointConfiguration.get().findEndpoint(serverUrl);
        if (endpoint instanceof BitbucketServerEndpoint) {
            return ((BitbucketServerEndpoint)endpoint).getServerVersion();
        }
        return BitbucketServerVersion.VERSION_7;
    }

    @NonNull
    public BitbucketServerVersion getServerVersion() {
        return this.serverVersion;
    }

    @DataBoundSetter
    public void setServerVersion(@NonNull BitbucketServerVersion serverVersion) {
        this.serverVersion = Objects.requireNonNull(serverVersion);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @NonNull
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    @NonNull
    public String getRepositoryUrl(@NonNull String repoOwner, @NonNull String repository) {
        UriTemplate template = UriTemplate.fromTemplate((String)(this.serverUrl + "/{userOrProject}/{owner}/repos/{repo}")).set("repo", (Object)repository);
        return repoOwner.startsWith("~") ? template.set("userOrProject", (Object)"users").set("owner", (Object)repoOwner.substring(1)).expand() : template.set("userOrProject", (Object)"projects").set("owner", (Object)repoOwner).expand();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Only non-null after we set them here!")
    private Object readResolve() {
        if (this.webhookImplementation == null) {
            this.webhookImplementation = BitbucketServerWebhookImplementation.PLUGIN;
        }
        if (this.getBitbucketJenkinsRootUrl() != null) {
            this.setBitbucketJenkinsRootUrl(this.getBitbucketJenkinsRootUrl());
        }
        if (this.serverVersion == null) {
            this.serverVersion = BitbucketServerVersion.VERSION_7;
        }
        return this;
    }

    @NonNull
    public BitbucketServerWebhookImplementation getWebhookImplementation() {
        return this.webhookImplementation;
    }

    @DataBoundSetter
    public void setWebhookImplementation(@NonNull BitbucketServerWebhookImplementation webhookImplementation) {
        this.webhookImplementation = Objects.requireNonNull(webhookImplementation);
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractBitbucketEndpointDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.BitbucketServerEndpoint_displayName();
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillWebhookImplementationItems() {
            ListBoxModel items = new ListBoxModel();
            for (BitbucketServerWebhookImplementation webhookImplementation : BitbucketServerWebhookImplementation.values()) {
                items.add((ModelObject)webhookImplementation, webhookImplementation.name());
            }
            return items;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillServerVersionItems() {
            ListBoxModel items = new ListBoxModel();
            for (BitbucketServerVersion serverVersion : BitbucketServerVersion.values()) {
                items.add((ModelObject)serverVersion, serverVersion.name());
            }
            return items;
        }

        public static FormValidation doCheckServerUrl(@QueryParameter String value) {
            try {
                new URL(value);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)("Invalid URL: " + e.getMessage()));
            }
            return FormValidation.ok();
        }
    }
}

