/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.client.events;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequestEvent;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.client.branch.BitbucketCloudBranch;
import com.cloudbees.jenkins.plugins.bitbucket.client.pullrequest.BitbucketPullRequestValue;
import com.cloudbees.jenkins.plugins.bitbucket.client.pullrequest.BitbucketPullRequestValueDestination;
import com.cloudbees.jenkins.plugins.bitbucket.client.pullrequest.BitbucketPullRequestValueRepository;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketCloudRepository;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketCloudRepositoryOwner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class BitbucketCloudPullRequestEvent
implements BitbucketPullRequestEvent {
    @JsonProperty(value="pullrequest")
    private BitbucketPullRequestValue pullRequest;
    private BitbucketCloudRepository repository;

    @Override
    public BitbucketPullRequest getPullRequest() {
        return this.pullRequest;
    }

    public void setPullRequest(BitbucketPullRequestValue pullRequest) {
        this.pullRequest = pullRequest;
        this.reconstructMissingData();
    }

    @Override
    public BitbucketRepository getRepository() {
        return this.repository;
    }

    public void setRepository(BitbucketCloudRepository repository) {
        this.repository = repository;
        this.reconstructMissingData();
    }

    private void reconstructMissingData() {
        if (this.repository != null && this.pullRequest != null) {
            BitbucketPullRequestValueDestination destination;
            BitbucketCloudRepository sourceRepository;
            BitbucketPullRequestValueRepository source = this.pullRequest.getSource();
            if (source != null && (sourceRepository = source.getRepository()) != null) {
                if (sourceRepository.getScm() == null) {
                    sourceRepository.setScm(this.repository.getScm());
                }
                if (sourceRepository.getOwner() == null) {
                    if (!sourceRepository.getOwnerName().equals(this.repository.getOwnerName())) {
                        BitbucketCloudRepositoryOwner owner = new BitbucketCloudRepositoryOwner();
                        owner.setUsername(sourceRepository.getOwnerName());
                        owner.setDisplayName(this.pullRequest.getAuthorLogin());
                        if (this.repository.isPrivate()) {
                            sourceRepository.setPrivate(this.repository.isPrivate());
                        }
                        sourceRepository.setOwner(owner);
                    } else {
                        sourceRepository.setOwner(this.repository.getOwner());
                        sourceRepository.setPrivate(this.repository.isPrivate());
                    }
                }
            }
            if (source != null) {
                BitbucketCloudBranch sourceBranch = source.getBranch();
                BitbucketCommit sourceCommit = source.getCommit();
                if (sourceCommit != null && sourceBranch != null) {
                    if (sourceBranch.getRawNode() == null) {
                        sourceBranch.setRawNode(source.getCommit().getHash());
                    }
                    if (sourceBranch.getDateMillis() == 0L) {
                        sourceBranch.setDateMillis(this.toDate(sourceCommit.getDate()));
                    }
                }
            }
            if ((destination = this.pullRequest.getDestination()) != null && destination.getRepository() != null) {
                if (destination.getRepository().getScm() == null) {
                    destination.getRepository().setScm(this.repository.getScm());
                }
                if (destination.getRepository().getOwner() == null && destination.getRepository().getOwnerName().equals(this.repository.getOwnerName())) {
                    destination.getRepository().setOwner(this.repository.getOwner());
                    destination.getRepository().setPrivate(this.repository.isPrivate());
                }
            }
            if (destination != null && destination.getCommit() != null && destination.getBranch() != null && destination.getBranch().getRawNode() == null) {
                destination.getBranch().setRawNode(destination.getCommit().getHash());
            }
        }
    }

    private long toDate(String dateStr) {
        if (StringUtils.isBlank((String)dateStr)) {
            return 0L;
        }
        SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        dateParser.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return dateParser.parse(dateStr).getTime();
        }
        catch (ParseException e) {
            return 0L;
        }
    }
}

