/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBranch;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBuildStatus;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepositoryProtocol;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketTeam;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWebHook;
import com.cloudbees.jenkins.plugins.bitbucket.avatars.AvatarCacheSource;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.UserRoleInRepository;
import com.cloudbees.jenkins.plugins.bitbucket.filesystem.BitbucketSCMFile;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import jenkins.scm.api.SCMFile;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public interface BitbucketApi {
    @NonNull
    public String getOwner();

    @CheckForNull
    public String getRepositoryName();

    @NonNull
    public String getRepositoryUri(@NonNull BitbucketRepositoryProtocol var1, @CheckForNull String var2, @NonNull String var3, @NonNull String var4);

    @NonNull
    public List<? extends BitbucketPullRequest> getPullRequests() throws IOException, InterruptedException;

    @NonNull
    public BitbucketPullRequest getPullRequestById(@NonNull Integer var1) throws IOException, InterruptedException;

    @NonNull
    public BitbucketRepository getRepository() throws IOException, InterruptedException;

    public void postCommitComment(@NonNull String var1, @NonNull String var2) throws IOException, InterruptedException;

    public boolean checkPathExists(@NonNull String var1, @NonNull String var2) throws IOException, InterruptedException;

    @CheckForNull
    public String getDefaultBranch() throws IOException, InterruptedException;

    @CheckForNull
    public BitbucketBranch getBranch(@NonNull String var1) throws IOException, InterruptedException;

    @NonNull
    public List<? extends BitbucketBranch> getBranches() throws IOException, InterruptedException;

    @CheckForNull
    public BitbucketBranch getTag(@NonNull String var1) throws IOException, InterruptedException;

    @NonNull
    public List<? extends BitbucketBranch> getTags() throws IOException, InterruptedException;

    @CheckForNull
    public BitbucketCommit resolveCommit(@NonNull String var1) throws IOException, InterruptedException;

    @NonNull
    public BitbucketCommit resolveCommit(@NonNull BitbucketPullRequest var1) throws IOException, InterruptedException;

    @NonNull
    public String resolveSourceFullHash(@NonNull BitbucketPullRequest var1) throws IOException, InterruptedException;

    public void registerCommitWebHook(@NonNull BitbucketWebHook var1) throws IOException, InterruptedException;

    public void updateCommitWebHook(@NonNull BitbucketWebHook var1) throws IOException, InterruptedException;

    public void removeCommitWebHook(@NonNull BitbucketWebHook var1) throws IOException, InterruptedException;

    @NonNull
    public List<? extends BitbucketWebHook> getWebHooks() throws IOException, InterruptedException;

    @CheckForNull
    public BitbucketTeam getTeam() throws IOException, InterruptedException;

    @CheckForNull
    public AvatarCacheSource.AvatarImage getTeamAvatar() throws IOException, InterruptedException;

    @NonNull
    public List<? extends BitbucketRepository> getRepositories(@CheckForNull UserRoleInRepository var1) throws IOException, InterruptedException;

    @NonNull
    public List<? extends BitbucketRepository> getRepositories() throws IOException, InterruptedException;

    public void postBuildStatus(@NonNull BitbucketBuildStatus var1) throws IOException, InterruptedException;

    public boolean isPrivate() throws IOException, InterruptedException;

    @Restricted(value={NoExternalUse.class})
    public Iterable<SCMFile> getDirectoryContent(BitbucketSCMFile var1) throws IOException, InterruptedException;

    @Restricted(value={NoExternalUse.class})
    public InputStream getFileContent(BitbucketSCMFile var1) throws IOException, InterruptedException;
}

