/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApiFactory;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRequestException;
import com.cloudbees.jenkins.plugins.bitbucket.avatars.AvatarCache;
import com.cloudbees.jenkins.plugins.bitbucket.avatars.AvatarCacheSource;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.scm.api.metadata.AvatarMetadataAction;
import org.acegisecurity.Authentication;

public class BitbucketTeamMetadataAction
extends AvatarMetadataAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BitbucketTeamMetadataAction.class.getName());
    private final BitbucketAvatarCacheSource avatarSource;

    public BitbucketTeamMetadataAction(String serverUrl, StandardCredentials credentials, String team) {
        this.avatarSource = new BitbucketAvatarCacheSource(serverUrl, credentials, team);
    }

    public String getAvatarImageOf(String size) {
        return this.avatarSource == null ? this.avatarIconClassNameImageOf(this.getAvatarIconClassName(), size) : AvatarCache.buildUrl(this.avatarSource, size);
    }

    public String getAvatarIconClassName() {
        return this.avatarSource == null ? "icon-bitbucket-logo" : null;
    }

    public String getAvatarDescription() {
        return Messages.BitbucketTeamMetadataAction_IconDescription();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BitbucketTeamMetadataAction that = (BitbucketTeamMetadataAction)((Object)o);
        if (this.avatarSource == null) {
            return that.avatarSource == null;
        }
        return this.avatarSource.equals(that.avatarSource);
    }

    public int hashCode() {
        return Objects.hashCode(this.avatarSource);
    }

    public String toString() {
        return "BitbucketTeamMetadataAction{, avatarSource='" + this.avatarSource + "'}";
    }

    public static class BitbucketAvatarCacheSource
    implements AvatarCacheSource,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String serverUrl;
        private StandardCredentials credentials;
        private final String repoOwner;

        public BitbucketAvatarCacheSource(String serverUrl, StandardCredentials credentials, String repoOwner) {
            this.serverUrl = serverUrl;
            this.credentials = credentials;
            this.repoOwner = repoOwner;
            LOGGER.log(Level.INFO, "Created: {0}", this.toString());
        }

        @Override
        public AvatarCacheSource.AvatarImage fetch(StandardCredentials credentials) {
            try {
                return this.doFetch(credentials);
            }
            catch (IOException e) {
                StandardCredentials standardCredentials;
                BitbucketRequestException bre;
                if (e.getCause() instanceof BitbucketRequestException && (bre = (BitbucketRequestException)e.getCause()).getHttpCode() == 401 && (standardCredentials = this.findCredentials()) != null) {
                    this.credentials = standardCredentials;
                    try {
                        return this.doFetch(this.credentials);
                    }
                    catch (IOException | InterruptedException ex) {
                        LOGGER.log(Level.INFO, ex.getClass().getName() + ": " + e.getMessage(), e);
                    }
                }
                LOGGER.log(Level.INFO, "IOException: " + e.getMessage(), e);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.INFO, "InterruptedException: " + e.getMessage(), e);
            }
            return null;
        }

        private StandardCredentials findCredentials() {
            try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
                StandardCredentials standardCredentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(this.credentials.getClass(), (Item)null, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)this.serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)this.credentials.getId()), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(this.credentials.getClass())})}));
                return standardCredentials;
            }
        }

        private AvatarCacheSource.AvatarImage doFetch(StandardCredentials credentials) throws IOException, InterruptedException {
            BitbucketAuthenticator authenticator = (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(this.serverUrl), (Credentials)credentials);
            BitbucketApi bitbucket = BitbucketApiFactory.newInstance(this.serverUrl, authenticator, this.repoOwner, null, null);
            return bitbucket.getTeamAvatar();
        }

        @Override
        public AvatarCacheSource.AvatarImage fetch() {
            if (this.credentials == null) {
                throw new UnsupportedOperationException("this method can be used only with credentials");
            }
            return this.fetch(this.credentials);
        }

        @Override
        public String hashKey() {
            return this.serverUrl + "::" + this.repoOwner + "::" + (this.credentials != null ? this.credentials.getId() : "");
        }

        @Override
        public boolean canFetch() {
            return this.serverUrl != null && this.repoOwner != null && !this.serverUrl.trim().isEmpty() && !this.repoOwner.trim().isEmpty();
        }

        public int hashCode() {
            return Objects.hashCode(this.hashKey());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BitbucketAvatarCacheSource that = (BitbucketAvatarCacheSource)o;
            return this.hashKey().equals(that.hashKey());
        }

        public String toString() {
            return "BitbucketAvatarSource(" + this.hashKey() + ")";
        }
    }
}

