/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTagSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.BranchSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBranch;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.TaskListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceRequest;

public class BitbucketSCMSourceRequest
extends SCMSourceRequest {
    private final boolean fetchBranches;
    private final boolean fetchTags;
    private final boolean fetchOriginPRs;
    private final boolean fetchForkPRs;
    private final boolean skipPublicPRs;
    @NonNull
    private final Set<ChangeRequestCheckoutStrategy> originPRStrategies;
    @NonNull
    private final Set<ChangeRequestCheckoutStrategy> forkPRStrategies;
    @CheckForNull
    private final Set<String> requestedPullRequestNumbers;
    @CheckForNull
    private final Set<String> requestedOriginBranchNames;
    @CheckForNull
    private final Set<String> requestedTagNames;
    @NonNull
    private final String repoOwner;
    @NonNull
    private final String repository;
    @CheckForNull
    private Iterable<BitbucketPullRequest> pullRequests;
    @CheckForNull
    private Iterable<BitbucketBranch> branches;
    private BitbucketApi api;
    private final BitbucketSCMSource source;
    private final Map<Integer, BitbucketPullRequest> pullRequestData;
    @CheckForNull
    private Iterable<BitbucketBranch> tags;

    protected BitbucketSCMSourceRequest(@NonNull BitbucketSCMSource source, @NonNull BitbucketSCMSourceContext context, @CheckForNull TaskListener listener) {
        super((SCMSource)source, (SCMSourceContext)context, listener);
        this.source = source;
        this.fetchBranches = context.wantBranches();
        this.fetchTags = context.wantTags();
        this.fetchOriginPRs = context.wantOriginPRs();
        this.fetchForkPRs = context.wantForkPRs();
        this.skipPublicPRs = context.skipPublicPRs();
        this.originPRStrategies = this.fetchOriginPRs && !context.originPRStrategies().isEmpty() ? Collections.unmodifiableSet(EnumSet.copyOf(context.originPRStrategies())) : Collections.emptySet();
        this.forkPRStrategies = this.fetchForkPRs && !context.forkPRStrategies().isEmpty() ? Collections.unmodifiableSet(EnumSet.copyOf(context.forkPRStrategies())) : Collections.emptySet();
        Set includes = context.observer().getIncludes();
        if (includes != null) {
            HashSet<String> pullRequestNumbers = new HashSet<String>(includes.size());
            HashSet<String> branchNames = new HashSet<String>(includes.size());
            HashSet<String> tagNames = new HashSet<String>(includes.size());
            for (SCMHead h : includes) {
                if (h instanceof BranchSCMHead) {
                    branchNames.add(h.getName());
                    continue;
                }
                if (h instanceof PullRequestSCMHead) {
                    pullRequestNumbers.add(((PullRequestSCMHead)h).getId());
                    if (SCMHeadOrigin.DEFAULT.equals((Object)h.getOrigin())) {
                        branchNames.add(((PullRequestSCMHead)h).getOriginName());
                    }
                    if (((PullRequestSCMHead)h).getCheckoutStrategy() != ChangeRequestCheckoutStrategy.MERGE) continue;
                    branchNames.add(((PullRequestSCMHead)h).getTarget().getName());
                    continue;
                }
                if (!(h instanceof BitbucketTagSCMHead)) continue;
                tagNames.add(h.getName());
            }
            this.requestedPullRequestNumbers = Collections.unmodifiableSet(pullRequestNumbers);
            this.requestedOriginBranchNames = Collections.unmodifiableSet(branchNames);
            this.requestedTagNames = Collections.unmodifiableSet(tagNames);
        } else {
            this.requestedPullRequestNumbers = null;
            this.requestedOriginBranchNames = null;
            this.requestedTagNames = null;
        }
        this.repoOwner = source.getRepoOwner();
        this.repository = source.getRepository();
        this.pullRequestData = new HashMap<Integer, BitbucketPullRequest>();
    }

    public final boolean isFetchBranches() {
        return this.fetchBranches;
    }

    public final boolean isFetchTags() {
        return this.fetchTags;
    }

    public final boolean isFetchPRs() {
        return this.isFetchOriginPRs() || this.isFetchForkPRs();
    }

    public final boolean isFetchOriginPRs() {
        return this.fetchOriginPRs;
    }

    public final boolean isFetchForkPRs() {
        return this.fetchForkPRs;
    }

    public final boolean isSkipPublicPRs() {
        return this.skipPublicPRs;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> getOriginPRStrategies() {
        return this.originPRStrategies;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> getForkPRStrategies() {
        return this.forkPRStrategies;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> getPRStrategies(boolean fork) {
        if (fork) {
            return this.fetchForkPRs ? this.getForkPRStrategies() : Collections.emptySet();
        }
        return this.fetchOriginPRs ? this.getOriginPRStrategies() : Collections.emptySet();
    }

    public final Map<Boolean, Set<ChangeRequestCheckoutStrategy>> getPRStrategies() {
        HashMap<Boolean, Set<ChangeRequestCheckoutStrategy>> result = new HashMap<Boolean, Set<ChangeRequestCheckoutStrategy>>();
        for (Boolean fork : new Boolean[]{Boolean.TRUE, Boolean.FALSE}) {
            result.put(fork, this.getPRStrategies(fork));
        }
        return result;
    }

    @CheckForNull
    public final Set<String> getRequestedPullRequestNumbers() {
        return this.requestedPullRequestNumbers;
    }

    @CheckForNull
    public final Set<String> getRequestedOriginBranchNames() {
        return this.requestedOriginBranchNames;
    }

    @CheckForNull
    public final Set<String> getRequestedTagNames() {
        return this.requestedTagNames;
    }

    @NonNull
    public final String getRepoOwner() {
        return this.repoOwner;
    }

    @NonNull
    public final String getRepository() {
        return this.repository;
    }

    public final void setPullRequests(@CheckForNull Iterable<BitbucketPullRequest> pullRequests) {
        this.pullRequests = pullRequests;
    }

    @NonNull
    public final Iterable<BitbucketPullRequest> getPullRequests() {
        return Util.fixNull(this.pullRequests);
    }

    public final BitbucketPullRequest getPullRequestById(Integer id) throws IOException, InterruptedException {
        if (!this.pullRequestData.containsKey(id)) {
            this.pullRequestData.put(id, this.getBitbucketApiClient().getPullRequestById(id));
        }
        return this.pullRequestData.get(id);
    }

    private final BitbucketApi getBitbucketApiClient() {
        if (this.api == null) {
            this.api = this.source.buildBitbucketClient();
        }
        return this.api;
    }

    public final void setBranches(@CheckForNull Iterable<BitbucketBranch> branches) {
        this.branches = branches;
    }

    @NonNull
    public final Iterable<BitbucketBranch> getBranches() {
        return Util.fixNull(this.branches);
    }

    public final void setTags(@CheckForNull Iterable<BitbucketBranch> tags) {
        this.tags = tags;
    }

    @NonNull
    public final Iterable<BitbucketBranch> getTags() {
        return Util.fixNull(this.tags);
    }

    public void close() throws IOException {
        if (this.pullRequests instanceof Closeable) {
            ((Closeable)((Object)this.pullRequests)).close();
        }
        if (this.branches instanceof Closeable) {
            ((Closeable)((Object)this.branches)).close();
        }
        super.close();
    }
}

