/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMNavigatorContext;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.trait.SCMNavigatorContext;
import jenkins.scm.api.trait.SCMNavigatorRequest;

public class BitbucketSCMNavigatorRequest
extends SCMNavigatorRequest {
    private final Map<String, BitbucketRepository> repositoryMap = new TreeMap<String, BitbucketRepository>();
    private final SCMSourceObserver observer;

    protected BitbucketSCMNavigatorRequest(@NonNull SCMNavigator source, @NonNull BitbucketSCMNavigatorContext context, @NonNull SCMSourceObserver observer) {
        super(source, (SCMNavigatorContext)context, observer);
        this.observer = observer;
    }

    public void withRepositories(List<? extends BitbucketRepository> repositories) {
        this.repositoryMap.clear();
        for (BitbucketRepository bitbucketRepository : repositories) {
            this.repositoryMap.put(bitbucketRepository.getRepositoryName(), bitbucketRepository);
        }
    }

    public Collection<BitbucketRepository> repositories() {
        List existingRepositories = this.observer.getContext().getSCMSources().stream().filter(BitbucketSCMSource.class::isInstance).map(BitbucketSCMSource.class::cast).map(BitbucketSCMSource::getRepository).collect(Collectors.toList());
        Set newRepositories = this.repositoryMap.entrySet().stream().filter(e -> !existingRepositories.contains(e.getKey())).map(Map.Entry::getValue).collect(Collectors.toCollection(LinkedHashSet::new));
        newRepositories.addAll(this.repositoryMap.values());
        return newRepositories;
    }

    public BitbucketRepository getBitbucketRepository(String repositoryName) {
        return this.repositoryMap.get(repositoryName);
    }
}

