/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketChangesetCommentNotifier;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.BranchDiscoveryTrait;
import com.cloudbees.jenkins.plugins.bitbucket.FirstCheckoutCompletedInvisibleAction;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBuildStatus;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudApiClient;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SCMListener;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;

public class BitbucketBuildStatusNotifications {
    private static String getRootURL(@NonNull Run<?, ?> build) {
        JenkinsLocationConfiguration cfg = JenkinsLocationConfiguration.get();
        if (cfg == null || cfg.getUrl() == null) {
            throw new IllegalStateException("Could not determine Jenkins URL.");
        }
        return DisplayURLProvider.get().getRunURL(build);
    }

    static String checkURL(@NonNull String url, BitbucketApi bitbucket) {
        try {
            URL anURL = new URL(url);
            if ("localhost".equals(anURL.getHost())) {
                throw new IllegalStateException("Jenkins URL cannot start with http://localhost");
            }
            if ("unconfigured-jenkins-location".equals(anURL.getHost())) {
                throw new IllegalStateException("Could not determine Jenkins URL.");
            }
            if (bitbucket instanceof BitbucketCloudApiClient && !anURL.getHost().contains(".")) {
                throw new IllegalStateException("Please use a fully qualified name or an IP address for Jenkins URL, this is required by Bitbucket cloud");
            }
            return url;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Bad Jenkins URL");
        }
    }

    private static void createStatus(@NonNull Run<?, ?> build, @NonNull TaskListener listener, @NonNull BitbucketApi bitbucket, @NonNull String key, @NonNull String hash) throws IOException, InterruptedException {
        BitbucketSCMSourceContext context;
        BitbucketBuildStatus.Status state;
        String statusDescription;
        String url;
        SCMSource source = SCMSource.SourceByItem.findSource((Item)build.getParent());
        if (!(source instanceof BitbucketSCMSource)) {
            return;
        }
        try {
            url = BitbucketBuildStatusNotifications.getRootURL(build);
            BitbucketBuildStatusNotifications.checkURL(url, bitbucket);
        }
        catch (IllegalStateException e) {
            listener.getLogger().println("Can not determine Jenkins root URL or Jenkins URL is not a valid URL regarding Bitbucket API. Commit status notifications are disabled until a root URL is configured in Jenkins global configuration. \nIllegalStateException: " + e.getMessage());
            return;
        }
        Result result = build.getResult();
        String name = build.getFullDisplayName();
        String buildDescription = build.getDescription();
        if (Result.SUCCESS.equals(result)) {
            statusDescription = StringUtils.defaultIfBlank((String)buildDescription, (String)"This commit looks good.");
            state = BitbucketBuildStatus.Status.SUCCESSFUL;
        } else if (Result.UNSTABLE.equals(result)) {
            statusDescription = StringUtils.defaultIfBlank((String)buildDescription, (String)"This commit has test failures.");
            context = (BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits());
            state = context.sendSuccessNotificationForUnstableBuild() ? BitbucketBuildStatus.Status.SUCCESSFUL : BitbucketBuildStatus.Status.FAILED;
        } else if (Result.FAILURE.equals(result)) {
            statusDescription = StringUtils.defaultIfBlank((String)buildDescription, (String)"There was a failure building this commit.");
            state = BitbucketBuildStatus.Status.FAILED;
        } else if (Result.NOT_BUILT.equals(result)) {
            statusDescription = StringUtils.defaultIfBlank((String)buildDescription, (String)"This commit was not built (probably the build was skipped)");
            context = (BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits());
            state = context.disableNotificationForNotBuildJobs() ? (bitbucket instanceof BitbucketCloudApiClient ? BitbucketBuildStatus.Status.STOPPED : null) : BitbucketBuildStatus.Status.SUCCESSFUL;
        } else if (result != null) {
            statusDescription = StringUtils.defaultIfBlank((String)buildDescription, (String)"Something is wrong with the build of this commit.");
            state = BitbucketBuildStatus.Status.FAILED;
        } else {
            statusDescription = StringUtils.defaultIfBlank((String)buildDescription, (String)"The build is in progress...");
            state = BitbucketBuildStatus.Status.INPROGRESS;
        }
        if (state != null) {
            BitbucketChangesetCommentNotifier notifier = new BitbucketChangesetCommentNotifier(bitbucket);
            notifier.buildStatus(new BitbucketBuildStatus(hash, statusDescription, state, url, key, name));
            if (result != null) {
                listener.getLogger().println("[Bitbucket] Build result notified");
            }
        } else {
            listener.getLogger().println("[Bitbucket] Skip result notification");
        }
    }

    @CheckForNull
    private static BitbucketSCMSource findBitbucketSCMSource(Run<?, ?> build) {
        SCMSource s = SCMSource.SourceByItem.findSource((Item)build.getParent());
        return s instanceof BitbucketSCMSource ? (BitbucketSCMSource)s : null;
    }

    private static void sendNotifications(BitbucketSCMSource source, Run<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        BitbucketApi bitbucket;
        String key;
        BitbucketSCMSourceContext sourceContext = (BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits());
        if (sourceContext.notificationsDisabled()) {
            return;
        }
        SCMRevision r = SCMRevisionAction.getRevision((SCMSource)source, build);
        if (r == null) {
            return;
        }
        String hash = BitbucketBuildStatusNotifications.getHash(r);
        if (hash == null) {
            return;
        }
        boolean shareBuildKeyBetweenBranchAndPR = sourceContext.filters().stream().anyMatch(filter -> filter instanceof BranchDiscoveryTrait.ExcludeOriginPRBranchesSCMHeadFilter);
        if (r instanceof PullRequestSCMRevision) {
            listener.getLogger().println("[Bitbucket] Notifying pull request build result");
            PullRequestSCMHead head = (PullRequestSCMHead)r.getHead();
            key = BitbucketBuildStatusNotifications.getBuildKey(build, head.getOriginName(), shareBuildKeyBetweenBranchAndPR);
            bitbucket = source.buildBitbucketClient(head);
        } else {
            listener.getLogger().println("[Bitbucket] Notifying commit build result");
            key = BitbucketBuildStatusNotifications.getBuildKey(build, r.getHead().getName(), shareBuildKeyBetweenBranchAndPR);
            bitbucket = source.buildBitbucketClient();
        }
        BitbucketBuildStatusNotifications.createStatus(build, listener, bitbucket, key, hash);
    }

    @CheckForNull
    private static String getHash(@CheckForNull SCMRevision revision) {
        if (revision instanceof PullRequestSCMRevision) {
            revision = ((PullRequestSCMRevision)((Object)revision)).getPull();
        }
        if (revision instanceof AbstractGitSCMSource.SCMRevisionImpl) {
            return ((AbstractGitSCMSource.SCMRevisionImpl)revision).getHash();
        }
        return null;
    }

    private static String getBuildKey(@NonNull Run<?, ?> build, String branch, boolean shareBuildKeyBetweenBranchAndPR) {
        String key;
        if (shareBuildKeyBetweenBranchAndPR) {
            String folderName = build.getParent().getParent().getFullName();
            key = String.format("%s/%s", folderName, branch);
        } else {
            key = build.getParent().getFullName();
        }
        return key;
    }

    @Extension
    public static class JobCompletedListener
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run<?, ?> build, TaskListener listener) {
            BitbucketSCMSource source = BitbucketBuildStatusNotifications.findBitbucketSCMSource(build);
            if (source == null) {
                return;
            }
            try {
                BitbucketBuildStatusNotifications.sendNotifications(source, build, listener);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace(listener.error("Could not send notifications"));
            }
        }
    }

    @Extension
    public static class JobCheckOutListener
    extends SCMListener {
        public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState pollingBaseline) throws Exception {
            boolean hasCompletedCheckoutBefore;
            BitbucketSCMSource source = BitbucketBuildStatusNotifications.findBitbucketSCMSource(build);
            if (source == null) {
                return;
            }
            SCMRevision r = SCMRevisionAction.getRevision((SCMSource)source, build);
            if (r == null) {
                return;
            }
            boolean bl = hasCompletedCheckoutBefore = build.getAction(FirstCheckoutCompletedInvisibleAction.class) != null;
            if (!hasCompletedCheckoutBefore) {
                build.addAction((Action)new FirstCheckoutCompletedInvisibleAction());
                try {
                    BitbucketBuildStatusNotifications.sendNotifications(source, build, listener);
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace(listener.error("Could not send notifications"));
                }
            }
        }
    }
}

