/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cloudstats;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Functions;
import hudson.model.Action;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;

public class PhaseExecutionAttachment
implements Action,
Serializable {
    @Nonnull
    private final ProvisioningActivity.Status status;
    @Nonnull
    private final String title;

    public PhaseExecutionAttachment(@Nonnull ProvisioningActivity.Status status, @Nonnull String title) {
        this.status = status;
        this.title = title;
    }

    @Nonnull
    public ProvisioningActivity.Status getStatus() {
        return this.status;
    }

    @Nonnull
    public String getTitle() {
        return this.title.replaceAll("\n", " ");
    }

    public String getIconFileName() {
        return null;
    }

    @Nonnull
    public String getDisplayName() {
        String title = this.getTitle();
        return title.length() < 50 ? title : title.substring(0, 49) + "\u2026";
    }

    @CheckForNull
    public String getUrlName() {
        return null;
    }

    public static final class ExceptionAttachment
    extends PhaseExecutionAttachment {
        public static final long serialVersionUID = 0L;
        @Deprecated
        private transient Throwable throwable;
        @Nonnull
        private String text;

        @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
        private Object readResolve() {
            if (this.text != null) {
                return this;
            }
            if (this.throwable == null) {
                this.text = "Plugin was unable to deserialize the exception from version 0.12 or older";
            } else {
                this.text = Functions.printThrowable((Throwable)this.throwable);
                this.throwable = null;
            }
            return this;
        }

        public ExceptionAttachment(@Nonnull ProvisioningActivity.Status status, @Nonnull Throwable throwable) {
            super(status, ExceptionAttachment.extractTitle(throwable));
            this.text = Functions.printThrowable((Throwable)throwable);
        }

        @VisibleForTesting
        static String extractTitle(@Nonnull Throwable throwable) {
            String message = throwable.getMessage();
            if (message == null) {
                return throwable.getClass().getSimpleName();
            }
            if (throwable instanceof NoSuchFileException || throwable instanceof FileNotFoundException) {
                return throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
            }
            return message;
        }

        public ExceptionAttachment(@Nonnull ProvisioningActivity.Status status, @Nonnull String title, @Nonnull Throwable throwable) {
            super(status, title);
            this.text = Functions.printThrowable((Throwable)throwable);
        }

        @Deprecated
        public Throwable getCause() {
            return this.throwable;
        }

        @Nonnull
        public String getText() {
            return this.text;
        }

        public String toString() {
            return "Exception attachment: " + this.getTitle();
        }

        @Override
        @Nonnull
        public String getUrlName() {
            return "exception";
        }
    }
}

