/*
 * Decompiled with CFR 0.152.
 */
package ci.with.toad.edge;

import ci.with.toad.edge.DatabaseSystem;
import ci.with.toad.edge.FileUtils;
import ci.with.toad.edge.FormValidationUtil;
import ci.with.toad.edge.MainConfiguration;
import ci.with.toad.edge.ProcessLauncher;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.HashMap;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class DeployScriptBuilder
extends Builder {
    private String out;
    private String in;
    private static final String IN = "IN";
    private static final String OUT = "OUT";

    @DataBoundConstructor
    public DeployScriptBuilder(String out, String in) {
        this.out = out;
        this.in = in;
    }

    public String getOut() {
        return this.out;
    }

    public String getIn() {
        return this.in;
    }

    private FilePath getTmpIn(AbstractBuild<?, ?> build) {
        return new FilePath(build.getWorkspace(), IN + build.number);
    }

    private FilePath getTmpOut(AbstractBuild<?, ?> build) {
        return new FilePath(build.getWorkspace(), OUT + build.number);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        System.setOut(listener.getLogger());
        System.setErr(listener.getLogger());
        this.copyBuildFiles(build, listener);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("-in", this.getTmpIn(build).toURI().getPath());
        arguments.put("-out", this.getTmpOut(build).toURI().getPath());
        arguments.put("-deploy", "");
        boolean result = ProcessLauncher.exec(arguments, build, launcher, listener) == 0;
        this.deleteBuildFiles(build, listener);
        return result;
    }

    private void copyBuildFiles(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath input = FileUtils.getFilePath(build, this.in);
        FilePath targetConnection = FileUtils.getFilePath(build, this.out);
        FilePath workspaceTarget = this.getTmpOut(build);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingXtoY", new Object[]{targetConnection, workspaceTarget}).toString());
        targetConnection.copyTo(workspaceTarget);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingFinished", new Object[0]).toString());
        FilePath workspaceInput = this.getTmpIn(build);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingXtoY", new Object[]{input, workspaceInput}).toString());
        input.copyTo(workspaceInput);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "CopyingFinished", new Object[0]).toString());
    }

    private void deleteBuildFiles(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath workspaceInput = this.getTmpIn(build);
        FilePath targetConnection = this.getTmpOut(build);
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "DeletingX", new Object[]{targetConnection}).toString());
        targetConnection.delete();
        listener.getLogger().println(new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "DeletingX", new Object[]{workspaceInput}).toString());
        workspaceInput.delete();
    }

    public ToadBuilderDescriptor getDescriptor() {
        return (ToadBuilderDescriptor)super.getDescriptor();
    }

    @Extension
    public static class ToadBuilderDescriptor
    extends BuildStepDescriptor<Builder> {
        public ToadBuilderDescriptor() {
            this.load();
        }

        public ListBoxModel doFillDatabaseSystemItems() {
            ListBoxModel items = new ListBoxModel();
            for (DatabaseSystem s : DatabaseSystem.values()) {
                items.add(s.getDisplayName(), s.name());
            }
            return items;
        }

        public FormValidation doCheckOut(@QueryParameter String value) {
            FormValidation emptyValidation = FormValidationUtil.doCheckEmptyValue(value, new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "TargetConnectionFile", new Object[0]).toString());
            if (emptyValidation != FormValidation.ok()) {
                return emptyValidation;
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIn(@QueryParameter String value) {
            FormValidation emptyValidation = FormValidationUtil.doCheckEmptyValue(value, new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "InputFileLocation", new Object[0]).toString());
            if (emptyValidation != FormValidation.ok()) {
                return emptyValidation;
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return new Localizable(ResourceBundleHolder.get(MainConfiguration.class), "DeployScript", new Object[0]).toString();
        }
    }
}

