/*
 * Decompiled with CFR 0.152.
 */
package io.chef.jenkins;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import io.chef.jenkins.ChefIdentity;
import io.chef.jenkins.ChefIdentityCleanup;
import java.io.IOException;
import java.util.List;
import jenkins.tasks.SimpleBuildWrapper;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ChefIdentityBuildWrapper
extends SimpleBuildWrapper {
    private final String jobIdentity;

    @DataBoundConstructor
    public ChefIdentityBuildWrapper(String jobIdentity) {
        this.jobIdentity = jobIdentity;
    }

    public String getJobIdentity() {
        return this.jobIdentity;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath ws, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        ChefIdentity chefIdentity;
        listener.getLogger().println("Running build with Chef Identity of " + this.jobIdentity);
        context.setDisposer((SimpleBuildWrapper.Disposer)new ChefIdentityCleanup.WrapperDisposerImpl());
        try {
            chefIdentity = this.getDescriptor().getChefIdentity(this.jobIdentity);
        }
        catch (InterruptedException e) {
            listener.getLogger().println(e.getMessage());
            throw new InterruptedException(e.getMessage());
        }
        if (ws != null) {
            try {
                if (!new FilePath(ws, ".chef/.jenkinsChefIdentity").readToString().equals(chefIdentity.getIdName())) {
                    listener.getLogger().println("Job's existing Chef Identity did not match.  Changing to " + chefIdentity.getIdName());
                    throw new IOException("Jenkins Chef Identity did not match");
                }
            }
            catch (IOException e) {
                new FilePath(ws, ".chef").mkdirs();
                new FilePath(ws, ".chef/.jenkinsChefIdentity").write(chefIdentity.getIdName(), "UTF-8");
                new FilePath(ws, ".chef/user.pem").write(chefIdentity.getPemKey(), "UTF-8");
                new FilePath(ws, ".chef/knife.rb").write(chefIdentity.getKnifeRb(), "UTF-8");
            }
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        private List<ChefIdentity> chefIdentities;

        public DescriptorImpl() {
            super(ChefIdentityBuildWrapper.class);
            this.load();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Chef Identity Plugin";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            Object identities = formData.get("chefIdentity");
            this.chefIdentities = !JSONNull.getInstance().equals(identities) ? req.bindJSONToList(ChefIdentity.class, identities) : null;
            this.save();
            return super.configure(req, formData);
        }

        public List<ChefIdentity> getChefIdentities() {
            return this.chefIdentities;
        }

        public ChefIdentity getChefIdentity(String idName) throws InterruptedException {
            for (ChefIdentity ident : this.chefIdentities) {
                if (ident == null || !ident.getIdName().equals(idName)) continue;
                return ident;
            }
            throw new InterruptedException("Chef Identity Plugin::Lookup of identity '" + idName + "' failed. Aborting build.");
        }

        public void setChefIdentities(List<ChefIdentity> chefIdentities) {
            this.chefIdentities = chefIdentities;
        }
    }
}

