/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.spring.security;

import java.util.ArrayList;
import java.util.List;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.security.cas.userdetails.AbstractCasAssertionUserDetailsService;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;

public final class CasUserDetailsService
extends AbstractCasAssertionUserDetailsService {
    public static final String NON_EXISTENT_PASSWORD_VALUE = "NO_PASSWORD";
    private String[] attributes;
    private boolean convertToUpperCase = true;
    private String[] defaultAuthorities;

    protected UserDetails loadUserDetails(Assertion assertion) {
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        if (this.attributes != null) {
            for (String attribute : this.attributes) {
                Object value = assertion.getPrincipal().getAttributes().get(attribute);
                if (value == null) continue;
                if (value instanceof List) {
                    List list = (List)value;
                    for (Object o : list) {
                        grantedAuthorities.add(new SimpleGrantedAuthority(this.convertToUpperCase ? o.toString().toUpperCase() : o.toString()));
                    }
                    continue;
                }
                grantedAuthorities.add(new SimpleGrantedAuthority(this.convertToUpperCase ? value.toString().toUpperCase() : value.toString()));
            }
        }
        if (this.defaultAuthorities != null) {
            for (String authority : this.defaultAuthorities) {
                grantedAuthorities.add(new SimpleGrantedAuthority(authority));
            }
        }
        return new User(assertion.getPrincipal().getName(), NON_EXISTENT_PASSWORD_VALUE, true, true, true, true, grantedAuthorities);
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String[] attributes) {
        this.attributes = attributes;
    }

    public boolean isConvertToUpperCase() {
        return this.convertToUpperCase;
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    public String[] getDefaultAuthorities() {
        return this.defaultAuthorities;
    }

    public void setDefaultAuthorities(String[] defaultAuthorities) {
        this.defaultAuthorities = defaultAuthorities;
    }
}

