/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cas.spring;

import hudson.model.User;
import hudson.model.UserProperty;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.jenkinsci.plugins.cas.spring.security.CasAuthentication;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.cas.authentication.CasAuthenticationToken;

public class CasEventListener
implements ApplicationListener {
    public static final String DEFAULT_FULL_NAME_ATTRIBUTE = "cn";
    public static final String DEFAULT_EMAIL_ATTRIBUTE = "mail";
    private String fullNameAttribute = "cn";
    private String emailAttribute = "mail";

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof AuthenticationSuccessEvent) {
            this.onSuccessfulAuthentication(((AuthenticationSuccessEvent)event).getAuthentication());
        } else if (event instanceof InteractiveAuthenticationSuccessEvent) {
            this.onSuccessfulInteractiveAuthentication(((InteractiveAuthenticationSuccessEvent)event).getAuthentication());
        }
    }

    protected void onSuccessfulAuthentication(org.springframework.security.core.Authentication authentication) {
        if (authentication instanceof CasAuthenticationToken) {
            CasAuthenticationToken casToken = (CasAuthenticationToken)authentication;
            try {
                this.syncUserAttributes(casToken);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void onSuccessfulInteractiveAuthentication(org.springframework.security.core.Authentication authentication) {
        if (authentication instanceof CasAuthenticationToken) {
            CasAuthenticationToken casToken = (CasAuthenticationToken)authentication;
            SecurityContextHolder.getContext().setAuthentication((Authentication)CasAuthentication.newInstance(casToken));
        }
    }

    protected void syncUserAttributes(CasAuthenticationToken casToken) throws IOException {
        String email;
        if (casToken.getAssertion() == null || casToken.getAssertion().getPrincipal() == null || casToken.getAssertion().getPrincipal().getAttributes() == null) {
            return;
        }
        User user = User.get((String)casToken.getName());
        String fullName = this.getAttributeValue(casToken, this.getFullNameAttribute());
        if (fullName != null) {
            user.setFullName(fullName);
        }
        if ((email = this.getAttributeValue(casToken, this.getEmailAttribute())) != null) {
            user.addProperty((UserProperty)new Mailer.UserProperty(email));
        }
        user.save();
    }

    protected String getAttributeValue(CasAuthenticationToken authToken, String attributeName) {
        Map attributes;
        Object attribute;
        if (authToken != null && authToken.getAssertion() != null && authToken.getAssertion().getPrincipal() != null && authToken.getAssertion().getPrincipal().getAttributes() != null && attributeName != null && (attribute = (attributes = authToken.getAssertion().getPrincipal().getAttributes()).get(attributeName)) != null) {
            if (attribute instanceof Collection) {
                return ((Collection)attribute).iterator().next().toString();
            }
            return attribute.toString();
        }
        return null;
    }

    public String getFullNameAttribute() {
        return this.fullNameAttribute;
    }

    public void setFullNameAttribute(String fullNameAttribute) {
        this.fullNameAttribute = fullNameAttribute == null ? DEFAULT_FULL_NAME_ATTRIBUTE : fullNameAttribute;
    }

    public String getEmailAttribute() {
        return this.emailAttribute;
    }

    public void setEmailAttribute(String emailAttribute) {
        this.emailAttribute = emailAttribute == null ? DEFAULT_EMAIL_ATTRIBUTE : emailAttribute;
    }
}

