/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestware.bumblebee.uft;

import com.agiletestware.bumblebee.JenkinsBuildLogger;
import com.agiletestware.bumblebee.client.api.BumblebeeParameters;
import com.agiletestware.bumblebee.client.runner.DefaultExecutionEnvironmentProvider;
import com.agiletestware.bumblebee.client.runner.ExecutionEnvironmentProvider;
import com.agiletestware.bumblebee.client.runner.ExternalProcessRunner;
import com.agiletestware.bumblebee.client.runner.Runner;
import com.agiletestware.bumblebee.client.uftrunner.UftRunnerParameters;
import com.agiletestware.bumblebee.client.utils.BuildLogger;
import com.agiletestware.bumblebee.uft.UftRunner;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.remoting.RoleChecker;

public class RunUftTestTask
implements Callable<Integer, Exception> {
    private static final long serialVersionUID = -2882280267417631378L;
    private final UftRunnerParameters parameters;
    private final TaskListener listener;
    private final FilePath jenkinsDirPath;
    private ExecutionEnvironmentProvider executionEnvironmentProvider;
    private Runner<UftRunnerParameters, Integer> uftRunner;

    public RunUftTestTask(UftRunnerParameters parameters, TaskListener listener, FilePath jenkinsDirPath, FilePath workspace) {
        this.parameters = parameters;
        this.listener = listener;
        this.jenkinsDirPath = jenkinsDirPath;
        this.uftRunner = new UftRunner(workspace, listener);
        this.executionEnvironmentProvider = new DefaultExecutionEnvironmentProvider();
    }

    public Integer call() throws Exception {
        this.validateParameters(this.parameters);
        File jenkinsDir = new File(this.jenkinsDirPath.getRemote());
        return (Integer)new ExternalProcessRunner(jenkinsDir, this.executionEnvironmentProvider).run(this.uftRunner, (BumblebeeParameters)this.parameters, (BuildLogger)new JenkinsBuildLogger(this.listener));
    }

    void setUftRunner(Runner<UftRunnerParameters, Integer> uftRunner) {
        this.uftRunner = uftRunner;
    }

    void setExecutionEnvironmentProvider(ExecutionEnvironmentProvider executionEnvironmentProvider) {
        this.executionEnvironmentProvider = executionEnvironmentProvider;
    }

    public void checkRoles(RoleChecker arg0) throws SecurityException {
    }

    private void validateParameters(UftRunnerParameters parameters) {
        this.assertNotEmpty(parameters.getBumbleBeeUrl(), "Bumblebee URL");
        String uftPath = parameters.getUftBatchRunnerExePath();
        this.assertNotEmpty(uftPath, "UFT Batch Runner");
        File uftRunner = new File(uftPath);
        if (!uftRunner.exists() || !uftRunner.isFile()) {
            throw new RuntimeException("UFT Batch Runner: " + uftRunner.getAbsolutePath() + " does not exist or not a file.");
        }
        this.assertNotEmpty(parameters.getTestPath(), "Test Path");
        this.assertNotEmpty(parameters.getOutputDirName(), "JUnit Results Directory");
    }

    private void assertNotEmpty(String value, String label) {
        if (StringUtils.isEmpty((String)value)) {
            throw new RuntimeException(label + " is not defined. Please check your configuration");
        }
    }
}

