/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestware.bumblebee.uft;

import com.agiletestware.bumblebee.BumblebeeGlobalConfig;
import com.agiletestware.bumblebee.uft.RunUftTestTask;
import com.agiletestware.bumblebee.uft.UftRunnerParametersFactory;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import jenkins.model.GlobalConfiguration;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class RunUftTestBuildStep
extends Builder
implements SimpleBuildStep {
    private final String testPath;
    private final String outputDirPath;

    @DataBoundConstructor
    public RunUftTestBuildStep(String testPath, String outputDirPath) {
        this.testPath = testPath;
        this.outputDirPath = outputDirPath;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Bumblebee: Run local UFT test");
        try {
            RunUftTestTask task = new RunUftTestTask(UftRunnerParametersFactory.THE_INSTANCE.create(this, (BumblebeeGlobalConfig)((Object)GlobalConfiguration.all().get(BumblebeeGlobalConfig.class)), run.getEnvironment(listener)), listener, run.getExecutor().getOwner().getNode().getRootPath(), workspace);
            int returnCode = (Integer)launcher.getChannel().call((Callable)task);
            if (returnCode != 0) {
                throw new AbortException("UFT test execution failed. See logs for details.");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public String getTestPath() {
        return this.testPath;
    }

    public String getOutputDirPath() {
        return this.outputDirPath;
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public Descriptor() {
            super(RunUftTestBuildStep.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Bumblebee Local UFT Test Runner";
        }
    }
}

