/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestware.bumblebee.testset;

import com.agiletestware.bumblebee.BumblebeeGlobalConfig;
import com.agiletestware.bumblebee.client.api.AlmRunMode;
import com.agiletestware.bumblebee.client.api.BaseParameters;
import com.agiletestware.bumblebee.client.testrunner.TestSetRunnerParameters;
import com.agiletestware.bumblebee.client.testrunner.TestSetRunnerParametersImpl;
import com.agiletestware.bumblebee.testset.RunTestSetTask;
import com.agiletestware.bumblebee.testset.TestSetEnvSpecificParameters;
import com.agiletestware.bumblebee.tracking.ClientType;
import com.agiletestware.bumblebee.util.BumblebeeUtils;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RunTestSetBuildStep
extends Builder
implements SimpleBuildStep {
    private static final String TEST_SET_DELIMETER = "\r\n";
    private final String domain;
    private final String project;
    private final AlmRunMode runMode;
    private final String host;
    private final String testSets;
    private final String outputDirPath;
    private final int timeOut;

    @DataBoundConstructor
    public RunTestSetBuildStep(String domain, String project, String runMode, String host, String testSets, String outputDirPath, int timeOut) {
        this.domain = domain;
        this.project = project;
        this.runMode = AlmRunMode.valueOf((String)runMode.toUpperCase());
        this.host = host;
        this.testSets = testSets;
        this.outputDirPath = outputDirPath;
        this.timeOut = timeOut;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Bumblebee: running test sets");
        try {
            RunTestSetTask task = new RunTestSetTask(listener, run.getExecutor().getOwner().getNode().getRootPath(), workspace, this.createParameters(run.getEnvironment(listener)));
            int returnCode = (Integer)launcher.getChannel().call((Callable)task);
            if (returnCode != 0) {
                throw new AbortException("Test set execution failed. See logs for details.");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private TestSetRunnerParameters createParameters(EnvVars envVars) {
        BumblebeeGlobalConfig globalConfig = (BumblebeeGlobalConfig)((Object)GlobalConfiguration.all().get(BumblebeeGlobalConfig.class));
        TestSetRunnerParametersImpl params = new TestSetRunnerParametersImpl();
        globalConfig.populateBaseParameters((BaseParameters)params);
        params.setDomain(this.getDomain());
        params.setProject(this.getProject());
        params.setRunMode(this.getRunMode());
        params.setHost(this.getHost());
        params.setOutputDirPath(this.getOutputDirPath());
        params.setTimeOut(this.getTimeOut());
        params.setClientType(ClientType.JENKINS);
        String sets = this.getTestSets();
        ArrayList<String> setsList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(sets, TEST_SET_DELIMETER);
        while (tokenizer.hasMoreTokens()) {
            setsList.add(tokenizer.nextToken());
        }
        params.setTestSets(setsList);
        return new TestSetEnvSpecificParameters((TestSetRunnerParameters)params, envVars);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getProject() {
        return this.project;
    }

    public AlmRunMode getRunMode() {
        return this.runMode;
    }

    public String getHost() {
        return this.host;
    }

    public String getTestSets() {
        return this.testSets;
    }

    public String getOutputDirPath() {
        return this.outputDirPath;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public Descriptor() {
            super(RunTestSetBuildStep.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Bumblebee HP ALM Test Set Runner";
        }

        public AlmRunMode[] getRunModes() {
            return AlmRunMode.values();
        }

        public FormValidation doCheckDomain(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String domain) {
            project.checkPermission(Job.CONFIGURE);
            return BumblebeeUtils.validateRequiredField(domain);
        }

        public FormValidation doCheckProject(@AncestorInPath AbstractProject<?, ?> abstrProject, @QueryParameter String project) {
            abstrProject.checkPermission(Job.CONFIGURE);
            return BumblebeeUtils.validateRequiredField(project);
        }

        public FormValidation doCheckHost(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String host, @QueryParameter AlmRunMode runMode) throws IOException, ServletException {
            project.checkPermission(Job.CONFIGURE);
            if (AlmRunMode.LOCAL == runMode || AlmRunMode.SCHEDULED == runMode || StringUtils.isNotEmpty((String)host)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)("Host cannot be empty when ALM Run Mode is " + runMode));
        }

        public FormValidation doCheckTestSets(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String testSets) {
            project.checkPermission(Job.CONFIGURE);
            if (StringUtils.isEmpty((String)testSets)) {
                return FormValidation.error((String)"Required");
            }
            StringTokenizer tokenizer = new StringTokenizer(testSets, RunTestSetBuildStep.TEST_SET_DELIMETER);
            while (tokenizer.hasMoreTokens()) {
                String testSet = tokenizer.nextToken();
                if (testSet.startsWith("Root\\")) continue;
                return FormValidation.error((String)"Test set must start with Root\\");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckOutputDirPath(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String checkOutputDirPath) {
            project.checkPermission(Job.CONFIGURE);
            return BumblebeeUtils.validateRequiredField(checkOutputDirPath);
        }
    }
}

