/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestware.bumblebee.pc;

import com.agiletestware.bumblebee.JenkinsBuildLogger;
import com.agiletestware.bumblebee.client.pc.RunPcTestCallable;
import com.agiletestware.bumblebee.client.pc.RunPcTestContext;
import com.agiletestware.bumblebee.client.utils.BuildLogger;
import com.agiletestware.bumblebee.client.utils.ObsoleteFileRemover;
import hudson.AbortException;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jenkinsci.remoting.RoleChecker;

class RunPerformanceTestCallable
implements Callable<Void, Exception> {
    private static final long serialVersionUID = -8912232168754236306L;
    private final RunPcTestContext context;
    private final TaskListener listener;
    private final long jenkinsBuildStartTime;

    public RunPerformanceTestCallable(RunPcTestContext context, TaskListener listener, long jenkinsBuildStartTime) {
        this.context = context;
        this.listener = listener;
        this.jenkinsBuildStartTime = jenkinsBuildStartTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void call() throws Exception {
        File outputDir = this.context.getOutputDir();
        int executionTimeout = this.context.getTimeout();
        JenkinsBuildLogger logger = new JenkinsBuildLogger(this.listener);
        if (outputDir.exists()) {
            ObsoleteFileRemover.THE_INSTANCE.deleteObsoleteFiles(outputDir, this.jenkinsBuildStartTime, (BuildLogger)logger);
        } else {
            outputDir.mkdir();
        }
        RunPcTestCallable callable = new RunPcTestCallable(this.context, (BuildLogger)logger);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future task = executor.submit(callable);
            try {
                if (executionTimeout > 0) {
                    task.get(executionTimeout, TimeUnit.SECONDS);
                } else {
                    task.get();
                }
            }
            catch (TimeoutException ex) {
                task.cancel(true);
                throw new AbortException("Timeout has occurred, but Performance Center task is still running. Terminating the task");
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("Error has occurred: " + e.getMessage());
                throw new RuntimeException("Exception during Performance Center task execution: " + e.getMessage(), e);
            }
        }
        finally {
            executor.shutdownNow();
        }
        return null;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }
}

