/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestware.bumblebee;

import com.agiletestware.bumblebee.JenkinsLogger;
import com.agiletestware.bumblebee.client.api.BaseParameters;
import com.agiletestware.bumblebee.client.api.BumblebeeApiImpl;
import com.agiletestware.bumblebee.client.utils.BuildLogger;
import com.agiletestware.bumblebee.client.utils.Messages;
import com.agiletestware.bumblebee.client.utils.UrlAvailableValidator;
import com.agiletestware.bumblebee.validator.CustomUrlAvailableValidator;
import com.agiletestware.bumblebee.validator.HpUrls;
import com.agiletestware.bumblebee.validator.HpUserValidator;
import com.agiletestware.bumblebee.validator.RegExpMatchValidator;
import com.agiletestware.bumblebee.validator.UftRunnerPathValidator;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class BumblebeeGlobalConfig
extends GlobalConfiguration {
    static final Logger LOGGER = Logger.getLogger(BumblebeeGlobalConfig.class.getName());
    private static final String PLUGIN_HELP_PAGE_URI = "/plugin/bumblebee/help/main.html";
    private static final String PLUGIN_DISPLAY_NAME = "Bumblebee  HP  ALM  Uploader";
    private static final CustomUrlAvailableValidator BUMBLEBEE_URL_VALIDATOR = new CustomUrlAvailableValidator("Bumblebee URL is required", "FAILED: Could not connect to {0}", new UrlAvailableValidator((BuildLogger)new JenkinsLogger(BumblebeeGlobalConfig.class)));
    private static final RegExpMatchValidator BUMBLEBEE_URL_REGEXP_VALIDATOR = new RegExpMatchValidator("Bumblebee URL should be http(s)://<bumblebee_server>:<port>/bumblebee", "^(https?)://[0-9a-zA-Z]([-.\\w]*[0-9a-zA-Z])*(:\\d*[^/])?\\/bumblebee$");
    private static final RegExpMatchValidator ALM_URL_REGEXP_VALIDATOR = new RegExpMatchValidator("HP ALM URL should be http(s)://<qcserver>:<qcport>/qcbin", "^(https?)\\:\\/\\/[0-9a-zA-Z]([-.\\w]*[0-9a-zA-Z])*(:\\d*[^\\/])?\\/qcbin$");
    private String bumblebeeUrl;
    private String qcUserName;
    private String password;
    private String qcUrl;
    private int timeOut;
    private String uftRunnerPath;
    private String pcUrl;
    private int pcTimeOut;
    private boolean skipConnectivityDiagnostic;

    public BumblebeeGlobalConfig() {
        this.load();
    }

    public String getDisplayName() {
        return PLUGIN_DISPLAY_NAME;
    }

    public String getHelpFile() {
        return PLUGIN_HELP_PAGE_URI;
    }

    public void populateBaseParameters(BaseParameters params) {
        params.setBumbleBeeUrl(this.getBumblebeeUrl());
        params.setEncryptedPassword(this.getPassword());
        params.setAlmUserName(this.getQcUserName());
        params.setAlmUrl(this.getQcUrl());
    }

    @RequirePOST
    public FormValidation doSaveConnection(@QueryParameter(value="bumblebeeUrl") String bumblebeeUrl, @QueryParameter(value="qcUrl") String qcUrl, @QueryParameter(value="qcUserName") String qcUserName, @QueryParameter(value="password") String password, @QueryParameter(value="timeOut") int timeOut, @QueryParameter(value="uftRunnerPath") String uftRunnerPath, @QueryParameter(value="pcUrl") String pcUrl, @QueryParameter(value="pcTimeOut") int pcTimeOut, @QueryParameter(value="skipConnectivityDiagnostic") boolean skipConnectivityDiagnostic) {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        String bumblebeeUrlTrimmed = Util.fixEmptyAndTrim((String)bumblebeeUrl);
        String qcUrlTrimmed = Util.fixEmptyAndTrim((String)qcUrl);
        String userNameTrimmed = Util.fixEmptyAndTrim((String)qcUserName);
        String uftRunnerPathTrimmed = Util.fixEmptyAndTrim((String)uftRunnerPath);
        String pcUrlTrimmed = Util.fixEmptyAndTrim((String)pcUrl);
        try {
            ArrayList<FormValidation> validators = new ArrayList<FormValidation>();
            if (!skipConnectivityDiagnostic) {
                validators.add(BUMBLEBEE_URL_VALIDATOR.validate(bumblebeeUrlTrimmed, timeOut));
            }
            validators.addAll(Arrays.asList(HpUserValidator.THE_INSTANCE.validate(userNameTrimmed, new HpUrls(qcUrl, pcUrl)), UftRunnerPathValidator.THE_INSTANCE.validate(uftRunnerPathTrimmed, null)));
            FormValidation validation = FormValidation.aggregate(validators);
            if (FormValidation.Kind.ERROR == validation.kind) {
                return validation;
            }
            this.bumblebeeUrl = bumblebeeUrlTrimmed;
            this.uftRunnerPath = uftRunnerPathTrimmed;
            this.qcUrl = qcUrlTrimmed;
            this.qcUserName = userNameTrimmed;
            this.timeOut = timeOut;
            this.pcUrl = pcUrlTrimmed;
            this.pcTimeOut = pcTimeOut;
            this.skipConnectivityDiagnostic = skipConnectivityDiagnostic;
            try (BumblebeeApiImpl bmapi = new BumblebeeApiImpl(this.bumblebeeUrl, this.timeOut);){
                if (StringUtils.isBlank((String)this.password) || !this.password.equals(password)) {
                    this.password = skipConnectivityDiagnostic ? StringUtils.trim((String)password) : bmapi.getEncryptedPassword(StringUtils.trim((String)password));
                }
            }
            this.save();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, null, e);
            return FormValidation.error((String)("FAILED: " + e.getMessage()));
        }
        return FormValidation.ok((String)"Configuration Saved");
    }

    public String getBumblebeeUrl() {
        return this.bumblebeeUrl;
    }

    public String getQcUserName() {
        return this.qcUserName;
    }

    public String getQcUrl() {
        return this.qcUrl;
    }

    public String getPassword() {
        return this.password;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public String getUftRunnerPath() {
        return this.uftRunnerPath;
    }

    public String getPcUrl() {
        return this.pcUrl;
    }

    public int getPcTimeOut() {
        return this.pcTimeOut;
    }

    public boolean isSkipConnectivityDiagnostic() {
        return this.skipConnectivityDiagnostic;
    }

    public FormValidation doCheckBumblebeeUrl(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String bumblebeeUrl) throws IOException, ServletException {
        return BUMBLEBEE_URL_REGEXP_VALIDATOR.validate(bumblebeeUrl, null);
    }

    public FormValidation doCheckQcUrl(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String qcUrl) throws IOException, ServletException {
        if (StringUtils.isEmpty((String)qcUrl)) {
            return FormValidation.ok();
        }
        return ALM_URL_REGEXP_VALIDATOR.validate(qcUrl, null);
    }

    public FormValidation doCheckQcUserName(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String qcUserName, @QueryParameter String qcUrl, @QueryParameter String pcUrl) throws IOException, ServletException {
        return HpUserValidator.THE_INSTANCE.validate(qcUserName, new HpUrls(qcUrl, pcUrl));
    }

    public FormValidation doCheckUftRunnerPath(@QueryParameter String uftRunnerPath) {
        return UftRunnerPathValidator.THE_INSTANCE.validate(uftRunnerPath, null);
    }

    public FormValidation doCheckSkipConnectivityDiagnostic(@QueryParameter boolean skipConnectivityDiagnostic) {
        return skipConnectivityDiagnostic ? FormValidation.warning((String)Messages.THE_INSTANCE.getWarningMessage(this.bumblebeeUrl)) : FormValidation.ok();
    }
}

