/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.builduser;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.triggers.SCMTrigger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.plugins.builduser.varsetter.impl.SCMTriggerCauseDeterminant;
import org.jenkinsci.plugins.builduser.varsetter.impl.UserCauseDeterminant;
import org.jenkinsci.plugins.builduser.varsetter.impl.UserIdCauseDeterminant;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildUser
extends SimpleBuildWrapper {
    private static final String EXTENSION_DISPLAY_NAME = "Set jenkins user build variables";

    @DataBoundConstructor
    public BuildUser() {
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        HashMap<String, String> variables = new HashMap<String, String>();
        this.makeUserBuildVariables(build, variables);
        for (Map.Entry entry : variables.entrySet()) {
            context.env((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void makeUserBuildVariables(@Nonnull Run build, @Nonnull Map<String, String> variables) {
        SCMTrigger.SCMTriggerCause scmTriggerCause;
        Run upstream;
        Job job;
        Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)build.getCause(Cause.UpstreamCause.class);
        if (upstreamCause != null && (job = (Job)Jenkins.getInstance().getItemByFullName(upstreamCause.getUpstreamProject(), Job.class)) != null && (upstream = job.getBuildByNumber(upstreamCause.getUpstreamBuild())) != null) {
            this.makeUserBuildVariables(upstream, variables);
        }
        if (new SCMTriggerCauseDeterminant().setJenkinsUserBuildVars(scmTriggerCause = (SCMTrigger.SCMTriggerCause)build.getCause(SCMTrigger.SCMTriggerCause.class), variables)) {
            return;
        }
        Cause.UserIdCause userIdCause = (Cause.UserIdCause)build.getCause(Cause.UserIdCause.class);
        if (new UserIdCauseDeterminant().setJenkinsUserBuildVars(userIdCause, variables)) {
            return;
        }
        Cause.UserCause userCause = (Cause.UserCause)build.getCause(Cause.UserCause.class);
        if (new UserCauseDeterminant().setJenkinsUserBuildVars(userCause, variables)) {
            return;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return BuildUser.EXTENSION_DISPLAY_NAME;
        }
    }
}

