/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.build_token_root;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.BuildAuthorizationToken;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.UnprotectedRootAction;
import hudson.security.ACL;
import hudson.security.csrf.CrumbExclusion;
import hudson.triggers.SCMTrigger;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.SCMTriggerItem;
import jenkins.util.TimeDuration;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class BuildRootAction
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(BuildRootAction.class.getName());
    public static final String URLNAME = "buildByToken";

    public String getUrlName() {
        return URLNAME;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public void doBuild(StaplerRequest req, StaplerResponse rsp, @QueryParameter String job, @QueryParameter TimeDuration delay) throws IOException, ServletException {
        ParametersDefinitionProperty pp;
        LOGGER.log(Level.FINE, "build on {0}", job);
        ParameterizedJobMixIn.ParameterizedJob p = this.project(job, req, rsp);
        if (delay == null) {
            delay = new TimeDuration((long)p.getQuietPeriod());
        }
        if ((pp = (ParametersDefinitionProperty)((Job)p).getProperty(ParametersDefinitionProperty.class)) != null) {
            LOGGER.fine("wrong kind");
            throw HttpResponses.error((int)400, (String)"Use /buildByToken/buildWithParameters for this job since it takes parameters");
        }
        Queue.WaitingItem item = Jenkins.getInstance().getQueue().schedule((Queue.Task)p, delay.getTime(), new Action[]{this.getBuildCause(req)});
        if (item != null) {
            rsp.sendRedirect(201, req.getContextPath() + '/' + item.getUrl());
        } else {
            rsp.sendRedirect(".");
        }
    }

    public void doBuildWithParameters(StaplerRequest req, StaplerResponse rsp, @QueryParameter String job, @QueryParameter TimeDuration delay) throws IOException, ServletException {
        ParametersDefinitionProperty pp;
        LOGGER.log(Level.FINE, "buildWithParameters on {0}", job);
        ParameterizedJobMixIn.ParameterizedJob p = this.project(job, req, rsp);
        if (delay == null) {
            delay = new TimeDuration((long)p.getQuietPeriod());
        }
        if ((pp = (ParametersDefinitionProperty)((Job)p).getProperty(ParametersDefinitionProperty.class)) == null) {
            LOGGER.fine("wrong kind");
            throw HttpResponses.error((int)400, (String)"Use /buildByToken/build for this job since it takes no parameters");
        }
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        for (ParameterDefinition d : pp.getParameterDefinitions()) {
            ParameterValue value = d.createValue(req);
            if (value == null) continue;
            values.add(value);
        }
        Queue.WaitingItem item = Jenkins.getInstance().getQueue().schedule((Queue.Task)p, delay.getTime(), new Action[]{new ParametersAction(values), this.getBuildCause(req)});
        if (item != null) {
            rsp.sendRedirect(201, req.getContextPath() + '/' + item.getUrl());
        } else {
            rsp.sendRedirect(".");
        }
    }

    public void doPolling(StaplerRequest req, StaplerResponse rsp, @QueryParameter String job) throws IOException, ServletException {
        LOGGER.log(Level.FINE, "polling on {0}", job);
        ParameterizedJobMixIn.ParameterizedJob p = this.project(job, req, rsp);
        SCMTriggerItem scmp = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)p);
        if (scmp == null) {
            LOGGER.log(Level.FINE, "{0} is not a SCMTriggerItem", p);
            throw HttpResponses.error((int)400, (Throwable)new IOException(job + " is not a SCMTriggerItem"));
        }
        SCMTrigger trigger = scmp.getSCMTrigger();
        if (trigger == null) {
            LOGGER.log(Level.FINE, "{0} is not configured to poll", p);
            throw HttpResponses.error((int)400, (Throwable)new IOException(job + " is not configured to poll"));
        }
        trigger.run();
        this.ok(rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParameterizedJobMixIn.ParameterizedJob project(String job, StaplerRequest req, StaplerResponse rsp) throws IOException, HttpResponses.HttpResponseException {
        Job j;
        SecurityContext orig = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            j = (Job)Jenkins.getInstance().getItemByFullName(job, Job.class);
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)orig);
        }
        if (j == null) {
            LOGGER.log(Level.FINE, "no such job {0}", job);
            throw HttpResponses.notFound();
        }
        if (!(j instanceof ParameterizedJobMixIn.ParameterizedJob)) {
            LOGGER.log(Level.FINE, "{0} is not a ParameterizedJob", j);
            throw HttpResponses.notFound();
        }
        ParameterizedJobMixIn.ParameterizedJob p = (ParameterizedJobMixIn.ParameterizedJob)j;
        BuildAuthorizationToken authToken = p.getAuthToken();
        if (authToken == null || authToken.getToken() == null) {
            LOGGER.log(Level.FINE, "no authToken on {0}", job);
            throw HttpResponses.notFound();
        }
        try {
            BuildAuthorizationToken.checkPermission((Job)((Job)p), (BuildAuthorizationToken)authToken, (StaplerRequest)req, (StaplerResponse)rsp);
        }
        catch (AccessDeniedException x) {
            LOGGER.log(Level.FINE, "on {0} was denied: {1}", new Object[]{job, x.getMessage()});
            throw x;
        }
        if (!j.isBuildable()) {
            LOGGER.log(Level.FINE, "{0} is not buildable", job);
            throw HttpResponses.error((int)400, (Throwable)new IOException(job + " is not buildable"));
        }
        LOGGER.log(Level.FINE, "found {0}", p);
        return p;
    }

    private CauseAction getBuildCause(StaplerRequest req) {
        return new CauseAction((Cause)new Cause.RemoteCause(req.getRemoteAddr(), req.getParameter("cause")));
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="https://github.com/spotbugs/spotbugs/issues/756")
    private void ok(StaplerResponse rsp) throws IOException {
        rsp.setContentType("text/html");
        try (PrintWriter w = rsp.getWriter();){
            w.write("Scheduled.\n");
        }
    }

    @Extension
    public static class BuildRootActionCrumbExclusion
    extends CrumbExclusion {
        public boolean process(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
            String pathInfo = req.getPathInfo();
            if (pathInfo != null && pathInfo.startsWith(this.getExclusionPath())) {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                return true;
            }
            return false;
        }

        public String getExclusionPath() {
            return "/buildByToken/";
        }
    }
}

