/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.buckminster.targetPlatform;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.buckminster.EclipseBuckminsterBuilder;
import hudson.plugins.buckminster.targetPlatform.TargetPlatformReference;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Messages;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetPlatformPublisher
extends ArtifactArchiver
implements DependecyDeclarer {
    private static final String TARGET_PLATFORM_DIRECTORY = "/targetPlatform";
    private String targetPlatformName;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public TargetPlatformPublisher(String artifacts, String excludes, boolean latestOnly, String targetPlatformName) {
        super(artifacts, excludes, latestOnly);
        this.targetPlatformName = targetPlatformName;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        if (this.getArtifacts().length() == 0) {
            listener.error(Messages.ArtifactArchiver_NoIncludes());
            build.setResult(Result.FAILURE);
            return true;
        }
        File dir = build.getArtifactsDir();
        dir = new File(dir, "targetPlatform");
        dir.mkdirs();
        listener.getLogger().println(Messages.ArtifactArchiver_ARCHIVING_ARTIFACTS());
        try {
            FilePath ws = build.getWorkspace();
            if (ws == null) {
                return true;
            }
            FilePath result = ws.child(this.getArtifacts());
            if (result.copyRecursiveTo(new FilePath(dir)) == 0) {
                if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE)) {
                    listener.error(Messages.ArtifactArchiver_NoMatchFound((Object)this.getArtifacts()));
                    String msg = ws.validateAntFileMask(this.getArtifacts());
                    if (msg != null) {
                        listener.error(msg);
                    }
                }
                build.setResult(Result.FAILURE);
                return true;
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.error(Messages.ArtifactArchiver_FailedToArchive((Object)this.getArtifacts())));
            return true;
        }
        return true;
    }

    public TargetPlatformReference getTargetPlatformReference(AbstractProject<?, ?> project) {
        TargetPlatformReference reference = new TargetPlatformReference();
        reference.setName(this.targetPlatformName);
        reference.setFullName(project.getFullName() + "/" + this.targetPlatformName);
        if (project.getLastSuccessfulBuild() != null) {
            String fullPath = ((AbstractBuild)project.getLastSuccessfulBuild()).getArtifactsDir().getAbsoluteFile().toURI().getPath() + TARGET_PLATFORM_DIRECTORY;
            reference.setPath(fullPath);
        }
        return reference;
    }

    public String getTargetPlatformName() {
        return this.targetPlatformName;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        TargetPlatformReference reference = this.getTargetPlatformReference(owner);
        if (reference == null || reference.getFullName() == null) {
            return;
        }
        List projects = Hudson.getInstance().getAllItems(Project.class);
        for (Project project : projects) {
            List builds = project.getBuilders();
            for (Object object : builds) {
                EclipseBuckminsterBuilder builder;
                if (!(object instanceof EclipseBuckminsterBuilder) || (builder = (EclipseBuckminsterBuilder)((Object)object)).getTargetPlatform() == null || !reference.getFullName().equals(builder.getTargetPlatform().getFullName())) continue;
                if (project instanceof MatrixConfiguration) {
                    MatrixProject matrix = (MatrixProject)project.getParent();
                    graph.addDependency(new DependencyGraph.Dependency(owner, (AbstractProject)matrix));
                    continue;
                }
                graph.addDependency(new DependencyGraph.Dependency(owner, (AbstractProject)project));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType) || MatrixProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return "Archive and publish an Eclipse Target Platform";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Publisher)req.bindJSON(TargetPlatformPublisher.class, formData);
        }

        public FormValidation doCheckArtifacts(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException {
            FilePath ws = project.getSomeWorkspace();
            return ws != null ? ws.validateRelativeDirectory(value) : FormValidation.ok();
        }

        public String getHelpFile() {
            return "/plugin/buckminster/help-targetPlatformPublisher.html";
        }
    }
}

