/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.buckminster.command;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.JDK;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.buckminster.BuckminsterInstallation;
import hudson.plugins.buckminster.callables.GetDirectorExecutable;
import hudson.plugins.buckminster.command.CaseInsensitiveMap;
import hudson.plugins.buckminster.install.BuckminsterInstallable;
import hudson.remoting.Callable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineBuilder {
    private BuckminsterInstallation installation;
    private String commands;
    private String logLevel;
    private String additionalParams;
    private String equinoxLauncherArgs;
    private FilePath hudsonWorkspaceRoot;
    private String userWorkspace;
    private String userTemp;
    private String userOutput;
    private String userCommandFile;
    private String propertyFile;

    public CommandLineBuilder(BuckminsterInstallation installation, String commands, String logLevel, String additionalParams, String userWorkspace, String userTemp, String userOutput, String userCommandFile, String propertyFile, String equinoxLauncherArgs) {
        this(installation);
        this.commands = commands;
        this.logLevel = logLevel;
        this.additionalParams = additionalParams;
        this.userWorkspace = userWorkspace;
        this.userTemp = userTemp;
        this.userOutput = userOutput;
        this.userCommandFile = userCommandFile;
        this.propertyFile = propertyFile;
        this.equinoxLauncherArgs = equinoxLauncherArgs;
    }

    CommandLineBuilder(BuckminsterInstallation installation) {
        this.installation = installation;
    }

    public static CommandLineBuilder forInstallation(BuckminsterInstallation installation) {
        return new CommandLineBuilder(installation);
    }

    public CommandLineBuilder commands(String commands) {
        this.commands = commands;
        return this;
    }

    public CommandLineBuilder loglevel(String loglevel) {
        this.logLevel = loglevel;
        return this;
    }

    public CommandLineBuilder additionalParams(String additionalParams) {
        this.additionalParams = additionalParams;
        return this;
    }

    public CommandLineBuilder equinoxLauncherArgs(String equinoxLauncherArgs) {
        this.equinoxLauncherArgs = equinoxLauncherArgs;
        return this;
    }

    public CommandLineBuilder userWorkspace(String userWorkspace) {
        this.userWorkspace = userWorkspace;
        return this;
    }

    public CommandLineBuilder userTemp(String userTemp) {
        this.userTemp = userTemp;
        return this;
    }

    public CommandLineBuilder userOutput(String userOutput) {
        this.userOutput = userOutput;
        return this;
    }

    public CommandLineBuilder userCommandFile(String userCommandFile) {
        this.userCommandFile = userCommandFile;
        return this;
    }

    public CommandLineBuilder propertyFile(String propertyFile) {
        this.propertyFile = propertyFile;
        return this;
    }

    public List<String> buildCommands(AbstractBuild<?, ?> build, BuildListener listener, Launcher launcher) throws MalformedURLException, IOException, InterruptedException {
        ArrayList<String> commandList = new ArrayList<String>();
        this.hudsonWorkspaceRoot = build.getWorkspace();
        commandList.add(this.getJavaExecutable(listener, launcher, build));
        CaseInsensitiveMap properties = new CaseInsensitiveMap((Map<? extends String, ? extends String>)build.getEnvironment((TaskListener)listener));
        properties.putAll(build.getBuildVariables());
        this.addJVMProperties(commandList, properties);
        FilePath commandsPath = this.getCommandFilePath(build, properties);
        this.addStarterParameters(build, commandList, properties);
        commandList.add("--loglevel");
        commandList.add(this.getLogLevel());
        if (this.getPropertyFile() != null && this.getPropertyFile().length() > 0) {
            commandList.add("-P");
            commandList.add(this.expandProperties(this.getPropertyFile(), properties));
        }
        commandList.add("-S");
        commandList.add(commandsPath.getRemote());
        if (this.userCommandFile == null || this.userCommandFile.length() == 0) {
            this.writeCommandFile(commandsPath, properties);
        }
        return commandList;
    }

    String getJavaExecutable(BuildListener listener, Launcher launcher, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        JDK jdk = build.getProject().getJDK();
        if (jdk != null) {
            jdk = jdk.forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
            jdk = jdk.forEnvironment(build.getEnvironment((TaskListener)listener));
        }
        if (jdk != null) {
            Boolean isWindows = !launcher.isUnix();
            FilePath javaExecutable = isWindows != false ? Computer.currentComputer().getNode().createPath(jdk.getHome()).child("bin").child("java.exe") : Computer.currentComputer().getNode().createPath(jdk.getHome()).child("bin").child("java");
            if (javaExecutable.exists()) {
                return javaExecutable.getRemote();
            }
            String message = "The configured JDK \"{0}\" points to \"{1}\" but no executable exists. Defaulting to \"java\"";
            message = MessageFormat.format(message, jdk.getName(), jdk.getHome());
            listener.error(message);
        }
        return "java";
    }

    FilePath getCommandFilePath(AbstractBuild<?, ?> build, Map<String, String> properties) {
        if (this.userCommandFile == null || this.userCommandFile.length() == 0) {
            return build.getWorkspace().child("commands.txt");
        }
        return build.getWorkspace().child(this.expandProperties(this.userCommandFile, properties));
    }

    public BuckminsterInstallation getInstallation() {
        return this.installation;
    }

    public String getCommands() {
        return this.commands;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getAdditionalParams() {
        return this.additionalParams;
    }

    public String getEquinoxLauncherArgs() {
        return this.equinoxLauncherArgs;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    void writeCommandFile(FilePath commandsPath, Map<String, String> properties) throws IOException, InterruptedException {
        commandsPath.write(this.expandProperties(this.getCommands(), properties), "UTF-8");
    }

    void addStarterParameters(AbstractBuild<?, ?> build, List<String> commandList, Map<String, String> properties) throws IOException, InterruptedException {
        commandList.add("-jar");
        commandList.add(this.findEquinoxLauncher());
        this.addEquinoxLauncherProperties(commandList, properties);
        commandList.add("-application");
        commandList.add("org.eclipse.buckminster.cmdline.headless");
        commandList.add("-data");
        String workspace = this.getDataPath(build, properties);
        commandList.add(workspace);
    }

    void addEquinoxLauncherProperties(List<String> commandList, Map<String, String> properties) {
        if (this.getEquinoxLauncherArgs() != null) {
            String[] equinoxArgs = this.getEquinoxLauncherArgs().split("[\n\r]+");
            for (int i = 0; i < equinoxArgs.length; ++i) {
                if (equinoxArgs[i].trim().length() <= 0) continue;
                String parameter = this.expandProperties(equinoxArgs[i], properties);
                commandList.add(parameter);
            }
        }
    }

    String getDataPath(AbstractBuild<?, ?> build, Map<String, String> properties) throws IOException, InterruptedException {
        if (this.userWorkspace == null || this.userWorkspace.length() == 0) {
            return this.hudsonWorkspaceRoot.getRemote();
        }
        return this.expandProperties(this.userWorkspace, properties);
    }

    void addJVMProperties(List<String> commandList, Map<String, String> properties) throws IOException, InterruptedException {
        commandList.add(MessageFormat.format("-Dbuckminster.output.root={0}", this.getOutputDir(properties)));
        commandList.add(MessageFormat.format("-Dbuckminster.temp.root={0}", this.getTempDir(properties)));
        String params = this.getInstallation().getParams();
        if (params != null) {
            String[] globalVMParams = params.split("[\n\r]+");
            for (int i = 0; i < globalVMParams.length; ++i) {
                if (globalVMParams[i].trim().length() <= 0) continue;
                commandList.add(this.expandProperties(globalVMParams[i], properties));
            }
            if (globalVMParams.length == 0) {
                commandList.add("-Xmx512m");
                commandList.add("-XX:PermSize=128m");
            }
        } else {
            commandList.add("-Xmx512m");
            commandList.add("-XX:PermSize=128m");
        }
        String jobParams = this.getAdditionalParams();
        if (jobParams != null) {
            String[] additionalJobParams = jobParams.split("[\n\r]+");
            for (int i = 0; i < additionalJobParams.length; ++i) {
                if (additionalJobParams[i].trim().length() <= 0) continue;
                String parameter = this.expandProperties(additionalJobParams[i], properties);
                commandList.add(parameter);
            }
        }
    }

    Object getTempDir(Map<String, String> properties) {
        if (this.userTemp == null || this.userTemp.length() == 0) {
            return this.hudsonWorkspaceRoot.child("buckminster.temp").getRemote();
        }
        return this.hudsonWorkspaceRoot.child(this.expandProperties(this.userTemp, properties)).getRemote();
    }

    String getOutputDir(Map<String, String> properties) {
        if (this.userOutput == null || this.userOutput.length() == 0) {
            return this.hudsonWorkspaceRoot.child("buckminster.output").getRemote();
        }
        return this.hudsonWorkspaceRoot.child(this.expandProperties(this.userOutput, properties)).getRemote();
    }

    String expandProperties(String string, Map<String, String> properties) {
        Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}", 2);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            if (matcher.group(1) == null || !properties.containsKey(matcher.group(1))) continue;
            String replacement = null;
            if (matcher.group(1).equalsIgnoreCase("WORKSPACE")) {
                String path = properties.get("WORKSPACE");
                if (!path.startsWith("/")) {
                    path = "/" + path.replace("\\", "/");
                }
                replacement = path;
            } else {
                replacement = properties.get(matcher.group(1));
            }
            string = string.replace(matcher.group(0), replacement);
        }
        return string;
    }

    String findEquinoxLauncher() throws IOException, InterruptedException {
        FilePath installationHome = Computer.currentComputer().getNode().createPath(this.getInstallation().getHome());
        FilePath pluginDir = installationHome.child("plugins");
        if (!pluginDir.exists()) {
            throw new FileNotFoundException("No 'plugins' directory has been found in " + this.installation.getHome());
        }
        List plugins = pluginDir.list();
        for (FilePath filePath : plugins) {
            if (!filePath.getName().startsWith("org.eclipse.equinox.launcher_")) continue;
            return filePath.getRemote();
        }
        throw new FileNotFoundException("No equinox launcher jar has been found in " + pluginDir.getRemote());
    }

    public static List<String> createDirectorScript(BuckminsterInstallable installable, FilePath toolDir, Node node, TaskListener log, Set<String> repositories, Set<String> featuresToInstall) throws IOException, InterruptedException {
        return CommandLineBuilder.createDirectorScript(installable, toolDir, node, log, repositories, featuresToInstall, new HashSet<String>());
    }

    public static List<String> createDirectorScript(BuckminsterInstallable installable, FilePath toolDir, Node node, TaskListener log, Set<String> repositories, Set<String> featuresToInstall, Set<String> featuresToUninstall) throws IOException, InterruptedException {
        ArrayList<String> commands = new ArrayList<String>();
        String executableName = (String)toolDir.getChannel().call((Callable)new GetDirectorExecutable());
        String directorInvocation = toolDir.child("director").child(executableName).getRemote();
        commands.add(directorInvocation);
        FilePath buckyDir = toolDir.child("buckminster");
        String buckyDirPath = buckyDir.getRemote();
        List jdks = Hudson.getInstance().getJDKs();
        if (jdks != null && jdks.size() > 0) {
            JDK jdk = (JDK)Hudson.getInstance().getJDKs().get(0);
            jdk = jdk.forNode(node, log);
            jdk = jdk.forEnvironment(node.toComputer().getEnvironment());
            commands.add("-vm");
            commands.add(node.createPath(jdk.getBinDir().getPath()).child("java").getRemote());
        }
        commands.add("-d");
        commands.add(buckyDirPath);
        commands.add("-p");
        commands.add("Buckminster");
        if (repositories.size() > 0) {
            commands.add("-r");
            commands.add(CommandLineBuilder.toCSV(repositories));
        }
        if (featuresToUninstall.size() > 0) {
            commands.add("-uninstallIU");
            commands.add(CommandLineBuilder.toCSV(featuresToUninstall));
        }
        if (featuresToInstall.size() > 0) {
            commands.add("-installIU");
            commands.add(CommandLineBuilder.toCSV(featuresToInstall));
        }
        return commands;
    }

    static String toCSV(Collection<String> values) {
        return CommandLineBuilder.toCSV(values, ", ");
    }

    static String toCSV(Collection<String> values, String separator) {
        if (values == null) {
            throw new IllegalArgumentException("values is null");
        }
        if (values.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String value : values) {
            builder.append(value);
            builder.append(separator);
        }
        builder.setLength(builder.length() - separator.length());
        return builder.toString();
    }
}

