/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.buckminster;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.buckminster.BuckminsterInstallation;
import hudson.plugins.buckminster.EclipseInstallation;
import hudson.plugins.buckminster.command.CommandLineBuilder;
import hudson.plugins.buckminster.targetPlatform.NoTargetPlatformReference;
import hudson.plugins.buckminster.targetPlatform.TargetPlatformPublisher;
import hudson.plugins.buckminster.targetPlatform.TargetPlatformReference;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.tools.ToolProperty;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseBuckminsterBuilder
extends Builder {
    private String installationName;
    private String commands;
    private String logLevel;
    private String params;
    private String targetPlatformName;
    private String userTemp;
    private String userOutput;
    private String userCommand;
    private String userWorkspace;
    private String globalPropertiesFile;
    private String equinoxLauncherArgs;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public EclipseBuckminsterBuilder(String installationName, String commands, String logLevel, String params, String targetPlatformName, String userTemp, String userOutput, String userCommand, String userWorkspace, String globalPropertiesFile, String equinoxLauncherArgs) {
        this.installationName = installationName;
        this.commands = commands;
        this.logLevel = logLevel;
        this.params = params;
        this.targetPlatformName = targetPlatformName;
        this.userTemp = userTemp;
        this.userOutput = userOutput;
        this.userCommand = userCommand;
        this.userWorkspace = userWorkspace;
        this.globalPropertiesFile = globalPropertiesFile;
        this.equinoxLauncherArgs = equinoxLauncherArgs;
    }

    public void setInstallationName(String installationName) {
        this.installationName = installationName;
    }

    public void setCommands(String commands) {
        this.commands = commands;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void setTargetPlatformName(String targetPlatformName) {
        this.targetPlatformName = targetPlatformName;
    }

    public void setUserTemp(String userTemp) {
        this.userTemp = userTemp;
    }

    public void setUserOutput(String userOutput) {
        this.userOutput = userOutput;
    }

    public void setUserCommand(String userCommand) {
        this.userCommand = userCommand;
    }

    public void setUserWorkspace(String userWorkspace) {
        this.userWorkspace = userWorkspace;
    }

    public void setGlobalPropertiesFile(String globalPropertiesFile) {
        this.globalPropertiesFile = globalPropertiesFile;
    }

    public void setEquinoxLauncherArgs(String equinoxLauncherArgs) {
        this.equinoxLauncherArgs = equinoxLauncherArgs;
    }

    public String getEclipseHome() {
        return this.getInstallation().getHome();
    }

    public String getCommands() {
        return this.commands;
    }

    public String getParams() {
        return this.params;
    }

    public String getEquinoxLauncherArgs() {
        return this.equinoxLauncherArgs;
    }

    public String getUserWorkspace() {
        return this.userWorkspace;
    }

    public String getLogLevel() {
        if (this.logLevel != null && this.logLevel.length() != 0) {
            return this.logLevel;
        }
        return "info";
    }

    public boolean isSelected(String item) {
        return this.getLogLevel().equals(item);
    }

    public BuckminsterInstallation getInstallation() {
        for (BuckminsterInstallation si : DESCRIPTOR.getBuckminsterInstallations()) {
            if (this.installationName == null || !si.getName().equals(this.installationName)) continue;
            return si;
        }
        return null;
    }

    public String getUserTemp() {
        return this.userTemp;
    }

    public String getUserOutput() {
        return this.userOutput;
    }

    public String getUserCommand() {
        return this.userCommand;
    }

    public TargetPlatformReference getTargetPlatform() {
        for (TargetPlatformReference reference : DESCRIPTOR.getTargetPlatforms()) {
            if (this.targetPlatformName == null || !reference.getName().equals(this.targetPlatformName)) continue;
            return reference;
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        try {
            BuckminsterInstallation installation = this.getInstallation();
            if (installation == null && (installation = this.pickDefault(listener)) == null) {
                listener.error("No Buckminster Tool Installation has been configured.");
                return false;
            }
            installation = installation.forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
            installation = installation.forEnvironment(build.getEnvironment((TaskListener)listener));
            String modifiedCommands = this.getCommands();
            TargetPlatformReference targetPlatform = this.getTargetPlatform();
            if (targetPlatform != null && targetPlatform.getPath() != null) {
                modifiedCommands = "setpref targetPlatformPath=\"" + targetPlatform.getPath() + "\"" + "\n" + modifiedCommands;
            }
            CommandLineBuilder cmdBuilder = CommandLineBuilder.forInstallation(installation).commands(modifiedCommands).loglevel(this.getLogLevel()).additionalParams(this.getParams()).userWorkspace(this.getUserWorkspace()).userTemp(this.getUserTemp()).userOutput(this.getUserOutput()).userCommandFile(this.getUserCommand()).propertyFile(this.getGlobalPropertiesFile()).equinoxLauncherArgs(this.getEquinoxLauncherArgs());
            List<String> buildCommands = cmdBuilder.buildCommands(build, listener, launcher);
            Proc proc = launcher.launch().envs((Map)build.getEnvironment((TaskListener)listener)).pwd(build.getWorkspace()).cmds(buildCommands).stdout((TaskListener)listener).start();
            return proc.join() == 0;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getGlobalPropertiesFile() {
        return this.globalPropertiesFile;
    }

    private BuckminsterInstallation pickDefault(BuildListener listener) {
        BuckminsterInstallation[] available = DESCRIPTOR.getBuckminsterInstallations();
        if (available == null || available.length == 0) {
            return null;
        }
        String message = "The selected Buckminster Tool Installation \"{0}\" has not been found, using \"{1}\" instead!";
        message = MessageFormat.format(message, this.installationName, available[0].getName());
        listener.error(message);
        return available[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private volatile BuckminsterInstallation[] buckminsterInstallations = new BuckminsterInstallation[0];
        private volatile EclipseInstallation[] installations = new EclipseInstallation[0];

        DescriptorImpl() {
            super(EclipseBuckminsterBuilder.class);
            this.load();
        }

        public List<TargetPlatformReference> getTargetPlatforms() {
            List projects = Hudson.getInstance().getAllItems(AbstractProject.class);
            ArrayList<TargetPlatformReference> references = new ArrayList<TargetPlatformReference>();
            references.add(new NoTargetPlatformReference());
            for (AbstractProject project : projects) {
                DescribableList publishersList = project.getPublishersList();
                for (Publisher describable : publishersList) {
                    TargetPlatformPublisher publisher;
                    TargetPlatformReference reference;
                    if (!(describable instanceof TargetPlatformPublisher) || (reference = (publisher = (TargetPlatformPublisher)describable).getTargetPlatformReference(project)) == null) continue;
                    references.add(reference);
                }
            }
            return references;
        }

        public EclipseInstallation[] getInstallations() {
            return this.installations;
        }

        public BuckminsterInstallation[] getBuckminsterInstallations() {
            if (this.installations != null && this.installations.length > 0) {
                List<BuckminsterInstallation> converted = this.convertLegacyInstallations(this.installations);
                if (this.buckminsterInstallations != null && this.buckminsterInstallations.length > 0) {
                    Collections.addAll(converted, this.buckminsterInstallations);
                }
                this.buckminsterInstallations = converted.toArray(new BuckminsterInstallation[converted.size()]);
                this.installations = new EclipseInstallation[0];
            }
            return this.buckminsterInstallations;
        }

        public FormValidation doCheckEclipseHome(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            String value = req.getParameter("value");
            File eclipseHome = new File(value);
            if (!eclipseHome.exists()) {
                String error = "The path {0} does not exist";
                error = MessageFormat.format(error, value);
                return FormValidation.error((String)error);
            }
            if (!eclipseHome.isDirectory()) {
                String error = "{0} is not a directory";
                error = MessageFormat.format(error, value);
                return FormValidation.error((String)error);
            }
            if (!new File(eclipseHome.getAbsolutePath() + "/plugins").exists()) {
                String error = "{0} does not contain a plugins directory";
                error = MessageFormat.format(error, value);
                return FormValidation.error((String)error);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEclipseVersion(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            String version = req.getParameter("value");
            if (!(version.startsWith("3.4") || version.startsWith("3.5") || version.startsWith("3.6") || version.startsWith("3.7"))) {
                return FormValidation.error((String)"Eclipse version is not valid. Currently only 3.4, 3.5, 3.6 and 3.7 are supported.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUserCommand(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException {
            FilePath path = project.getSomeWorkspace();
            if (path == null) {
                return FormValidation.ok();
            }
            return path.validateRelativePath(value, true, true);
        }

        public FormValidation doCheckGlobalPropertiesFile(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException {
            FilePath path = project.getSomeWorkspace();
            if (path == null) {
                return FormValidation.ok();
            }
            return path.validateRelativePath(value, true, true);
        }

        public String getDisplayName() {
            return "Run Buckminster";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            this.save();
            return super.configure(req, o);
        }

        private List<BuckminsterInstallation> convertLegacyInstallations(EclipseInstallation[] installations) {
            ArrayList<BuckminsterInstallation> convertedInstallations = new ArrayList<BuckminsterInstallation>(installations.length);
            for (EclipseInstallation eclipseInstallation : installations) {
                BuckminsterInstallation inst = new BuckminsterInstallation(eclipseInstallation.getName(), eclipseInstallation.getHome(), eclipseInstallation.getVersion(), eclipseInstallation.getParams(), Collections.<ToolProperty<?>>emptyList());
                convertedInstallations.add(inst);
            }
            return convertedInstallations;
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)req.bindJSON(EclipseBuckminsterBuilder.class, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType) || MatrixProject.class.isAssignableFrom(jobType);
        }

        public void setBuckminsterInstallations(BuckminsterInstallation ... installations) {
            this.buckminsterInstallations = installations;
            this.save();
        }
    }
}

