/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.buckminster;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.DownloadService;
import hudson.model.EnvironmentSpecific;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.buckminster.EclipseBuckminsterBuilder;
import hudson.plugins.buckminster.callables.GetDirectorExecutable;
import hudson.plugins.buckminster.command.CommandLineBuilder;
import hudson.plugins.buckminster.install.BuckminsterInstallable;
import hudson.plugins.buckminster.util.ReadDelegatingTextFile;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.DownloadFromUrlInstaller;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import hudson.util.TextFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuckminsterInstallation
extends ToolInstallation
implements EnvironmentSpecific<BuckminsterInstallation>,
NodeSpecific<BuckminsterInstallation> {
    private static final long serialVersionUID = -7771376893768609115L;
    private String version;
    private String params;

    @DataBoundConstructor
    public BuckminsterInstallation(String name, String home, String version, String params, List<ToolProperty<?>> properties) {
        super(name, home, properties);
        this.version = version;
        this.params = params;
    }

    public String getParams() {
        return this.params;
    }

    public String getVersion() {
        return this.version;
    }

    public BuckminsterInstallation forEnvironment(EnvVars environment) {
        return new BuckminsterInstallation(this.getName(), environment.expand(this.getHome()), this.version, this.params, this.getProperties().toList());
    }

    public BuckminsterInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new BuckminsterInstallation(this.getName(), this.translateFor(node, log), this.version, this.params, this.getProperties().toList());
    }

    public boolean exists() {
        String home = this.getHome();
        File f = new File(home);
        File buckyDir = new File(f, "buckminster");
        if (!buckyDir.exists()) {
            return false;
        }
        File executableWin = new File(buckyDir, "buckminster.bat");
        File executableUnix = new File(buckyDir, "buckminster");
        return executableWin.exists() || executableUnix.exists();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BuckminsterInstaller
    extends DownloadFromUrlInstaller {
        private boolean update;

        @DataBoundConstructor
        public BuckminsterInstaller(String id, boolean update) {
            super(id);
            this.update = update;
        }

        protected FilePath findPullUpDirectory(FilePath root) throws IOException, InterruptedException {
            return null;
        }

        public boolean isUpdate() {
            return this.update;
        }

        public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
            FilePath toolHome = super.performInstallation(tool, node, log);
            FilePath buckminsterDir = toolHome.child("buckminster");
            BuckminsterInstallable inst = (BuckminsterInstallable)this.getInstallable();
            HashSet<String> repositories = new HashSet<String>();
            HashSet<String> featuresToInstall = new HashSet<String>();
            HashSet<String> featuresToUninstall = new HashSet<String>();
            if (buckminsterDir.exists()) {
                FilePath executableWin = buckminsterDir.child("buckminster.bat");
                FilePath executableUnix = buckminsterDir.child("buckminster");
                if (executableUnix.exists() || executableWin.exists()) {
                    if (this.isUpdate()) {
                        log.getLogger().println("Checking for Buckminster Updates");
                        Map<String, Set<String>> installedFeatures = this.readInstalledFeatures(buckminsterDir, log);
                        for (Map.Entry<String, Set<String>> entry : installedFeatures.entrySet()) {
                            for (String feature : entry.getValue()) {
                                featuresToUninstall.add(feature + ".feature.group");
                            }
                        }
                        for (BuckminsterInstallable.Repository repo : inst.repositories) {
                            repositories.add(repo.url);
                            for (BuckminsterInstallable.Feature feature : repo.features) {
                                featuresToInstall.add(feature.id + ".feature.group");
                            }
                        }
                        List<String> commands = CommandLineBuilder.createDirectorScript(inst, toolHome, node, log, repositories, featuresToInstall, featuresToUninstall);
                        this.executeScript(node, log, toolHome, commands);
                        this.writeInstallationDetails(node, log, buckminsterDir, inst);
                    }
                    return buckminsterDir;
                }
            }
            featuresToInstall.add(inst.iu);
            repositories.add(inst.repositoryURL);
            for (BuckminsterInstallable.Repository repo : inst.repositories) {
                repositories.add(repo.url);
                for (BuckminsterInstallable.Feature feature : repo.features) {
                    featuresToInstall.add(feature.id + ".feature.group");
                }
            }
            List<String> commands = CommandLineBuilder.createDirectorScript(inst, toolHome, node, log, repositories, featuresToInstall);
            this.executeScript(node, log, toolHome, commands);
            this.writeInstallationDetails(node, log, buckminsterDir, inst);
            return buckminsterDir;
        }

        protected boolean isUpToDate(FilePath expectedLocation, DownloadFromUrlInstaller.Installable i) throws IOException, InterruptedException {
            boolean upToDate = super.isUpToDate(expectedLocation, i);
            if (!upToDate) {
                return upToDate;
            }
            FilePath child = expectedLocation.child("director");
            String executableName = (String)expectedLocation.getChannel().call((Callable)new GetDirectorExecutable());
            child = child.child(executableName);
            return child.exists();
        }

        private void writeInstallationDetails(Node node, TaskListener log, FilePath buckminsterDir, BuckminsterInstallable inst) throws InterruptedException, IOException {
            FilePath installedFeatures = buckminsterDir.child(".installedFeatures");
            StringBuilder installed = new StringBuilder();
            for (BuckminsterInstallable.Repository repo : inst.repositories) {
                installed.append(repo.url);
                installed.append("\n");
                for (BuckminsterInstallable.Feature feature : repo.features) {
                    installed.append("-");
                    installed.append(feature.id);
                    installed.append("\n");
                }
            }
            try {
                installedFeatures.write(installed.toString(), "UTF-8");
            }
            catch (InterruptedException e) {
                installedFeatures.delete();
                throw e;
            }
        }

        private Map<String, Set<String>> readInstalledFeatures(FilePath buckminsterDir, TaskListener log) throws IOException, InterruptedException {
            HashMap<String, Set<String>> installed = new HashMap<String, Set<String>>();
            FilePath installedFeatures = buckminsterDir.child(".installedFeatures");
            if (!installedFeatures.exists()) {
                String message = "{0} is missing. This file contains the information which features have already been installed into buckminster. The Update will not be accurate without this file.";
                message = MessageFormat.format(message, installedFeatures.toURI().getPath());
                log.error(message);
                return installed;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(installedFeatures.read(), "UTF-8"));
            String s = null;
            String url = null;
            HashSet<String> features = new HashSet<String>();
            while ((s = reader.readLine()) != null) {
                if (s.startsWith("-")) {
                    features.add(s.substring(1));
                    continue;
                }
                if (url != null && features.size() > 0) {
                    installed.put(url, features);
                    features = new HashSet();
                }
                url = s;
            }
            if (url != null && features.size() > 0) {
                installed.put(url, features);
                features = new HashSet();
            }
            url = s;
            return installed;
        }

        private void executeScript(Node node, TaskListener log, FilePath targetDir, List<String> commands) throws IOException, InterruptedException {
            int r = node.createLauncher(log).launch().cmds(commands).stdout(log).pwd(targetDir).join();
            if (r != 0) {
                throw new IOException("Command returned status " + r);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Extension
        public static final class DescriptorImpl
        extends DownloadFromUrlInstaller.DescriptorImpl<BuckminsterInstaller> {
            public String getDisplayName() {
                return "Install from Eclipse.org and Cloudsmith.com";
            }

            public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
                return toolType == BuckminsterInstallation.class;
            }

            protected DownloadService.Downloadable createDownloadable() {
                return new DownloadService.Downloadable(this.getId()){

                    public TextFile getDataFile() {
                        TextFile updateFile = super.getDataFile();
                        TextFile userOverride = new TextFile(new File(Hudson.getInstance().getRootDir(), "userContent/buckminster/buckminster.json"));
                        return new ReadDelegatingTextFile(updateFile, userOverride);
                    }
                };
            }

            public List<? extends DownloadFromUrlInstaller.Installable> getInstallables() throws IOException {
                JSONObject d = DownloadService.Downloadable.get((String)this.getId()).getData();
                if (d == null) {
                    return Collections.emptyList();
                }
                return Arrays.asList(((BuckminsterInstallable.BuckminsterInstallableList)JSONObject.toBean((JSONObject)d, BuckminsterInstallable.BuckminsterInstallableList.class)).buckminsters);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<BuckminsterInstallation> {
        public String getDisplayName() {
            return "Buckminster";
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.singletonList(new BuckminsterInstaller(null, false));
        }

        public BuckminsterInstallation[] getInstallations() {
            return ((EclipseBuckminsterBuilder.DescriptorImpl)Hudson.getInstance().getDescriptorByType(EclipseBuckminsterBuilder.DescriptorImpl.class)).getBuckminsterInstallations();
        }

        public void setInstallations(BuckminsterInstallation ... installations) {
            ((EclipseBuckminsterBuilder.DescriptorImpl)Hudson.getInstance().getDescriptorByType(EclipseBuckminsterBuilder.DescriptorImpl.class)).setBuckminsterInstallations(installations);
        }
    }
}

