/*
 * Decompiled with CFR 0.152.
 */
package jenkins.bouncycastle.api;

import hudson.Main;
import hudson.Plugin;
import hudson.PluginWrapper;
import hudson.remoting.Which;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.bouncycastle.api.SecurityProviderInitializer;
import jenkins.model.Jenkins;
import jenkins.util.AntClassLoader;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;

@Restricted(value={NoExternalUse.class})
public class BouncyCastlePlugin
extends Plugin {
    private static final Logger LOG = Logger.getLogger(BouncyCastlePlugin.class.getName());
    private static final boolean isActive;

    /*
     * Enabled aggressive block sorting
     */
    @SuppressRestrictedWarnings(value={AntClassLoader.class})
    public void start() throws Exception {
        if (!isActive) {
            return;
        }
        File optionalLibDir = this.getOptionalLibDirectory();
        File[] optionalLibs = optionalLibDir.listFiles();
        if (optionalLibs == null || optionalLibs.length == 0) {
            if (!Main.isUnitTest) {
                LOG.log(Level.WARNING, "No optional-libs not found at {0}, BouncyCastle APIs will be unavailable causing strange runtime issues.", optionalLibDir);
                throw new IllegalStateException("BouncyCastle libs are missing from WEB-INF/optional-libs");
            }
            LOG.log(Level.INFO, "{0} not found; for non RealJenkinsRule this is fine and can be ignored.", optionalLibDir);
        } else {
            VersionNumber version = Jenkins.getVersion();
            if (version != null && version.isNewerThan(new VersionNumber("2.312"))) {
                Method m = this.getWrapper().getClass().getMethod("injectJarsToClasspath", File[].class);
                m.invoke((Object)this.getWrapper(), new Object[]{optionalLibs});
            } else {
                AntClassLoader cl = (AntClassLoader)this.getWrapper().classLoader;
                for (File optionalLib : optionalLibs) {
                    LOG.log(Level.CONFIG, () -> "Inserting " + optionalLib + " into bouncycastle-api plugin classpath");
                    cl.addPathComponent(optionalLib);
                }
            }
        }
        SecurityProviderInitializer.addSecurityProvider();
    }

    public static boolean isActive() {
        return isActive;
    }

    private final File getOptionalLibDirectory() throws IOException {
        File here;
        File alt;
        File f;
        PluginWrapper pw = this.getWrapper();
        File explodedPluginsDir = pw.parent.getWorkDir();
        if (explodedPluginsDir == null) {
            explodedPluginsDir = new File(Jenkins.get().getRootDir(), "plugins");
            LOG.log(Level.FINE, "plugindir not specified, falling back to $'{'JENKINS_HOME/plugins'}' as {0}", explodedPluginsDir);
        }
        if (!(f = new File(explodedPluginsDir, pw.getShortName() + "/WEB-INF/optional-lib/")).isDirectory() && (alt = new File((here = Which.jarFile(BouncyCastlePlugin.class)).getParentFile().getParentFile(), "optional-lib")).isDirectory()) {
            LOG.log(Level.FINE, "fallback based on {0}", here);
            f = alt;
        }
        LOG.log(Level.FINE, "using {0} as the optional-lib directory", f);
        return f;
    }

    static {
        Provider p = Security.getProvider("BCFIPS");
        isActive = p == null;
        LOG.log(Level.CONFIG, isActive ? "BouncyCastle Providers from BouncyCastle API plugin will be active" : "Detected the presence of the BouncyCastle FIPS provider, the regular BouncyCastle JARs will not be available.");
    }
}

