/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.bearychat;

import hudson.ProxyConfiguration;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.bearychat.BearyChatService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;

public class StandardBearyChatService
implements BearyChatService {
    private static final Logger logger = Logger.getLogger(StandardBearyChatService.class.getName());
    public static final String VERSION = "3.0";
    private String webhook;
    private String channel;

    public StandardBearyChatService(String webhook, String channel) {
        this.webhook = webhook;
        this.channel = channel;
    }

    public JSONObject genAttachment(String title, String text, String color, String url) {
        JSONObject attachment = new JSONObject();
        if (title != null) {
            attachment.put("title", (Object)title);
        }
        if (text != null) {
            attachment.put("text", (Object)text);
        }
        if (color != null) {
            attachment.put("color", (Object)color);
        }
        if (url != null) {
            attachment.put("url", (Object)url);
        }
        return attachment;
    }

    @Override
    public boolean publish(String message) {
        JSONObject data = new JSONObject();
        data.put("text", (Object)message);
        return this.publish(data);
    }

    @Override
    public boolean publish(String message, String text, String fallback, String color) {
        JSONObject attachment = this.genAttachment(null, text, color, null);
        JSONArray attachments = new JSONArray();
        attachments.add((Object)attachment);
        return this.publish(message, attachments, fallback);
    }

    @Override
    public boolean publish(String message, JSONArray attachments, String fallback) {
        JSONObject data = new JSONObject();
        if (fallback != null) {
            data.put("fallback", (Object)fallback);
        }
        data.put("text", (Object)message);
        data.put("attachments", (Object)attachments);
        return this.publish(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean publish(JSONObject data) {
        boolean result = true;
        String url = this.getPostUrl();
        logger.info("Post to " + this.channel + " on " + url + ": " + data);
        HttpClient client = this.getHttpClient();
        PostMethod post = new PostMethod(url);
        if (this.channel != null) {
            data.put("channel", (Object)this.channel);
        }
        try {
            post.addRequestHeader("X-JENKINS-VERSION", Jenkins.VERSION);
            post.addRequestHeader("X-PLUGIN-VERSION", VERSION);
            post.addParameter("payload", data.toString());
            post.getParams().setContentCharset("UTF-8");
            int responseCode = client.executeMethod((HttpMethod)post);
            String response = post.getResponseBodyAsString();
            if (responseCode != 200) {
                logger.log(Level.WARNING, "BearyChat post may have failed. Response: " + response);
                result = false;
            } else {
                logger.info("Posting succeeded");
            }
        }
        catch (NullPointerException e) {
            result = false;
        }
        catch (Exception e) {
            result = false;
            logger.log(Level.WARNING, "Error posting to BearyChat", e);
        }
        finally {
            post.releaseConnection();
        }
        return result;
    }

    public String getPostUrl() {
        return this.webhook + "?v=" + VERSION;
    }

    protected HttpClient getHttpClient() {
        ProxyConfiguration proxy;
        HttpClient client = new HttpClient();
        Jenkins instance = Jenkins.getInstance();
        ProxyConfiguration proxyConfiguration = proxy = instance == null ? null : instance.proxy;
        if (proxy != null) {
            client.getHostConfiguration().setProxy(proxy.name, proxy.port);
            String username = proxy.getUserName();
            String password = proxy.getPassword();
            if (username != null && !"".equals(username.trim())) {
                logger.info("Using proxy authentication (user=" + username + ")");
                client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            }
        }
        return client;
    }
}

