/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.bearychat;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.tasks.Publisher;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.plugins.bearychat.ActiveNotifier;
import jenkins.plugins.bearychat.BearyChatNotifier;
import jenkins.plugins.bearychat.DisabledNotifier;
import jenkins.plugins.bearychat.FineGrainedNotifier;

@Extension
public class BearyChatListener
extends RunListener<AbstractBuild> {
    private static final Logger logger = Logger.getLogger(BearyChatListener.class.getName());

    public BearyChatListener() {
        super(AbstractBuild.class);
    }

    public void onCompleted(AbstractBuild r, TaskListener listener) {
        this.getNotifier(r.getProject(), listener).completed(r);
        super.onCompleted((Run)r, listener);
    }

    public void onStarted(AbstractBuild r, TaskListener listener) {
    }

    public void onDeleted(AbstractBuild r) {
    }

    public void onFinalized(AbstractBuild r) {
    }

    FineGrainedNotifier getNotifier(AbstractProject project, TaskListener listener) {
        Map map = project.getPublishersList().toMap();
        for (Publisher publisher : map.values()) {
            if (!(publisher instanceof BearyChatNotifier)) continue;
            return new ActiveNotifier((BearyChatNotifier)publisher, (BuildListener)listener);
        }
        return new DisabledNotifier();
    }
}

