/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.beakerbuilder.utils;

import hudson.model.BuildListener;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import org.jenkinsci.plugins.beakerbuilder.utils.BeakerConsoleAnnotator;

public class ConsoleLogger {
    private final BuildListener listener;
    private final BeakerConsoleAnnotator annotator;

    public ConsoleLogger(BuildListener listener) {
        this.listener = listener;
        this.annotator = new BeakerConsoleAnnotator(this.listener.getLogger());
    }

    public BuildListener getListener() {
        return this.listener;
    }

    public PrintStream getLogger() {
        return this.listener.getLogger();
    }

    public void logAnnot(String message) {
        byte[] msg = (message + "\n").getBytes(Charset.defaultCharset());
        try {
            this.annotator.eol(msg, msg.length);
        }
        catch (IOException e) {
            this.listener.getLogger().println("Problem with writing into console log: " + e.getMessage());
        }
    }

    public void log(String message) {
        this.listener.getLogger().println(message);
    }
}

