/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.beakerbuilder;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.beakerbuilder.JobSource;
import org.kohsuke.stapler.DataBoundConstructor;

public class FileJobSource
extends JobSource {
    private String jobPath;

    @DataBoundConstructor
    public FileJobSource(String jobPath) {
        this.jobPath = jobPath;
    }

    public String getJobPath() {
        return this.jobPath;
    }

    @Override
    protected String getDeclaredContent(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        FilePath fp = new FilePath(build.getWorkspace(), this.expandJobPath(build, listener));
        return fp.readToString();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptor(this.getClass());
    }

    protected String expandJobPath(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        String expandedPath = this.getJobPath();
        ParametersAction pa = (ParametersAction)build.getAction(ParametersAction.class);
        if (pa != null) {
            expandedPath = pa.substitute(build, expandedPath);
        }
        return build.getEnvironment((TaskListener)listener).expand(expandedPath);
    }

    @Extension
    public static class DescriptorImpl
    extends JobSource.JobSourceDescriptor {
        public String getDisplayName() {
            return "File job source";
        }
    }
}

