/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.bart;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.github.tzemp.config.Config;
import com.github.tzemp.parser.Parser;
import com.github.tzemp.parser.ParserSummary;
import com.github.tzemp.parser.StackExchangeQuestionEvaluation;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class LogParserBuildAction
implements Action {
    private String message;
    private AbstractBuild<?, ?> build;
    private ParserSummary parserSummary;
    private List<StackExchangeQuestionEvaluation> evaluations;

    public String getIconFileName() {
        return "star-gold.png";
    }

    public String getDisplayName() {
        return "BART";
    }

    public String getUrlName() {
        return "bart";
    }

    public String getMessage() {
        return this.message;
    }

    public List<StackExchangeQuestionEvaluation> getEvaluations() {
        return this.evaluations;
    }

    public ParserSummary getParserSummary() {
        return this.parserSummary;
    }

    public int getBuildNumber() {
        return this.build.number;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    LogParserBuildAction(String message, AbstractBuild<?, ?> build) throws IOException {
        System.out.print("START PARSER");
        this.build = build;
        Config config = this.readConfig();
        Parser parser = new Parser(build.getLog(Integer.MAX_VALUE), config);
        this.message = StringUtils.join((Object[])parser.print().toArray(), (char)'\n');
        this.parserSummary = parser.getParserSummary();
        this.evaluations = parser.getEvaluations();
    }

    private Config readConfig() {
        System.out.print("START READING CONFIG");
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            Config config = (Config)mapper.readValue(new File("src/config/config.yaml"), Config.class);
            System.out.print("END READING CONFIG - SUCCESS");
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.print("END READING CONFIG - FAILURE");
            return null;
        }
    }
}

