/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog.repositorybrowser;

import hudson.model.Run;
import hudson.plugins.backlog.BacklogProjectProperty;
import hudson.scm.ChangeLogSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryBrowserHelper {
    private static final Log LOG = LogFactory.getLog(RepositoryBrowserHelper.class);
    private String url;

    public RepositoryBrowserHelper(String url) {
        this.url = url;
    }

    public BacklogProjectProperty getProjectProperty(ChangeLogSet.Entry cs) {
        Run run = cs.getParent().getRun();
        return (BacklogProjectProperty)run.getParent().getProperty(BacklogProjectProperty.class);
    }

    public String getSpaceURL(ChangeLogSet.Entry cs) {
        if (this.isDefaultUrl()) {
            BacklogProjectProperty property = this.getProjectProperty(cs);
            if (property == null || property.getSpaceURL() == null) {
                LOG.warn((Object)"BacklogProjectProperty is null or BacklogProjectProperty's spaceURL is null");
                return null;
            }
            return property.getSpaceURL();
        }
        if (!this.url.contains("/projects/")) {
            LOG.warn((Object)"Option project url is not correct");
            return null;
        }
        return this.url.substring(0, this.url.indexOf("/projects/") + 1);
    }

    public String getProject(ChangeLogSet.Entry cs) {
        if (this.isDefaultUrl()) {
            BacklogProjectProperty property = this.getProjectProperty(cs);
            if (property == null || property.getProject() == null) {
                LOG.warn((Object)"BacklogProjectProperty is null or BacklogProjectProperty's project is null");
                return null;
            }
            return property.getProject();
        }
        if (!this.url.contains("/projects/")) {
            LOG.warn((Object)"Option project url is not correct");
            return null;
        }
        return this.url.substring(this.url.indexOf("/projects/") + "/projects/".length());
    }

    public boolean isDefaultUrl() {
        return StringUtils.isEmpty((String)this.url);
    }
}

