/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog.pipeline;

import com.nulabinc.backlog4j.PullRequest;
import hudson.plugins.backlog.BacklogLinkAction;
import hudson.plugins.backlog.pipeline.BacklogPullRequestSCMSource;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jgit.transport.URIish;

public class BacklogPullRequestLinkAction
extends BacklogLinkAction {
    private final transient BacklogPullRequestSCMSource source;
    private final transient PullRequest pullRequest;

    public BacklogPullRequestLinkAction(BacklogPullRequestSCMSource source, PullRequest pullRequest) {
        super(source.getBpp());
        this.source = source;
        this.pullRequest = pullRequest;
    }

    @Override
    public String getUrlName() {
        try {
            String repoName = new URIish(new URL(this.source.getRemote())).getHumanishName();
            return String.format("%sgit/%s/%s/pullRequests/%d", this.prop.getSpaceURL(), this.prop.getProject(), repoName, this.pullRequest.getNumber());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

