/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog.api.v2;

import com.nulabinc.backlog4j.BacklogClient;
import com.nulabinc.backlog4j.conf.BacklogConfigure;
import com.nulabinc.backlog4j.conf.BacklogPackageConfigure;
import hudson.plugins.backlog.BacklogProjectProperty;
import java.net.MalformedURLException;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public class BacklogClientFactory {
    public static BacklogClient getBacklogClient(BacklogProjectProperty bpp) throws MalformedURLException {
        if (bpp == null) {
            throw new IllegalArgumentException("'Backlog property' is not set. Can't comment a pull request.");
        }
        if (StringUtils.isEmpty((String)bpp.getSpaceURL())) {
            throw new IllegalArgumentException("'Backlog URL' is not set. Can't comment a pull request.");
        }
        if (StringUtils.isEmpty((String)bpp.getProject())) {
            throw new IllegalArgumentException("'project' is not included in Backlog URL. Can't comment a pull request.");
        }
        if (StringUtils.isEmpty((String)bpp.getApiKey())) {
            throw new IllegalArgumentException("'apiKey' is not set. Can't comment a pull request.");
        }
        if (Jenkins.getInstance().getPlugin("git") == null) {
            throw new IllegalArgumentException("This project doesn't use Git as SCM. Can't comment a pull request.");
        }
        BacklogConfigure configure = new BacklogPackageConfigure(bpp.getSpaceURL()).apiKey(bpp.getApiKey());
        return new com.nulabinc.backlog4j.BacklogClientFactory(configure).newClient();
    }
}

