/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.backlog.repositorybrowser.RepositoryBrowserHelper;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import org.kohsuke.stapler.DataBoundConstructor;

public class BacklogRepositoryBrowser
extends SubversionRepositoryBrowser {
    public final String url;

    @DataBoundConstructor
    public BacklogRepositoryBrowser(String url) {
        this.url = url;
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        RepositoryBrowserHelper helper = new RepositoryBrowserHelper(this.url);
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        SubversionChangeLogSet.LogEntry logEntry = path.getLogEntry();
        if (helper.getSpaceURL((ChangeLogSet.Entry)logEntry) == null || helper.getProject((ChangeLogSet.Entry)logEntry) == null) {
            return null;
        }
        String filePath = path.getPath();
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        String encodedPath = URLEncoder.encode(filePath, "UTF-8");
        return new URL(helper.getSpaceURL((ChangeLogSet.Entry)logEntry) + "ViewRepositoryFileDiff.action?projectKey=" + helper.getProject((ChangeLogSet.Entry)logEntry) + "&path=" + encodedPath + "&fromRevision=-1&toRevision=" + logEntry.getRevision());
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        RepositoryBrowserHelper helper = new RepositoryBrowserHelper(this.url);
        if (path.getEditType() == EditType.DELETE) {
            return null;
        }
        SubversionChangeLogSet.LogEntry logEntry = path.getLogEntry();
        if (helper.getSpaceURL((ChangeLogSet.Entry)logEntry) == null || helper.getProject((ChangeLogSet.Entry)logEntry) == null) {
            return null;
        }
        String filePath = path.getPath();
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        String encodedPath = URLEncoder.encode(filePath, "UTF-8");
        return new URL(helper.getSpaceURL((ChangeLogSet.Entry)logEntry) + "ViewRepositoryFile.action?projectKey=" + helper.getProject((ChangeLogSet.Entry)logEntry) + "&r=" + logEntry.getRevision() + "&path=" + encodedPath);
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        RepositoryBrowserHelper helper = new RepositoryBrowserHelper(this.url);
        if (helper.getSpaceURL((ChangeLogSet.Entry)changeSet) == null || helper.getProject((ChangeLogSet.Entry)changeSet) == null) {
            return null;
        }
        return new URL(helper.getSpaceURL((ChangeLogSet.Entry)changeSet) + "rev/" + helper.getProject((ChangeLogSet.Entry)changeSet) + "/" + changeSet.getRevision());
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public DescriptorImpl() {
            super(BacklogRepositoryBrowser.class);
        }

        public String getDisplayName() {
            return "Backlog";
        }
    }
}

