/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.keyvault;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.microsoft.azure.keyvault.models.SecretBundle;
import com.microsoft.jenkins.keyvault.BaseSecretCredentials;
import com.microsoft.jenkins.keyvault.Messages;
import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.Secret;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SecretStringCredentials
extends BaseSecretCredentials
implements StringCredentials {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public SecretStringCredentials(CredentialsScope scope, String id, String description, String servicePrincipalId, String secretIdentifier) {
        super(scope, id, description, servicePrincipalId, secretIdentifier);
    }

    @Nonnull
    public Secret getSecret() {
        SecretBundle secretBundle = this.getKeyVaultSecret();
        return Secret.fromString((String)secretBundle.value());
    }

    @Extension
    public static class DescriptorImpl
    extends BaseSecretCredentials.DescriptorImpl {
        public String getDisplayName() {
            return Messages.String_Credentials_Diaplay_Name();
        }

        public FormValidation doVerifyConfiguration(@QueryParameter String servicePrincipalId, @QueryParameter String secretIdentifier) {
            SecretStringCredentials credentials = new SecretStringCredentials(CredentialsScope.SYSTEM, "", "", servicePrincipalId, secretIdentifier);
            try {
                credentials.getSecret();
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) {
                    message = Messages.String_Credentials_Validation_Invalid();
                }
                return FormValidation.error((String)message);
            }
            return FormValidation.ok((String)Messages.String_Credentials_Validation_OK());
        }
    }
}

