/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.keyvault;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.microsoft.azure.keyvault.models.SecretBundle;
import com.microsoft.jenkins.keyvault.BaseSecretCredentials;
import com.microsoft.jenkins.keyvault.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Base64;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SecretCertificateCredentials
extends BaseSecretCredentials
implements StandardCertificateCredentials {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(SecretCertificateCredentials.class.getName());
    private final Secret password;

    @DataBoundConstructor
    public SecretCertificateCredentials(CredentialsScope scope, String id, String description, String servicePrincipalId, String secretIdentifier, Secret password) {
        super(scope, id, description, servicePrincipalId, secretIdentifier);
        this.password = password;
    }

    @NonNull
    public Secret getPassword() {
        return this.password;
    }

    @CheckForNull
    private static char[] toCharArray(@Nonnull Secret password) {
        String plainText = Util.fixEmpty((String)password.getPlainText());
        if (plainText == null) {
            return null;
        }
        return plainText.toCharArray();
    }

    @NonNull
    public KeyStore getKeyStore() {
        KeyStore keyStore;
        SecretBundle secretBundle = this.getKeyVaultSecret();
        try {
            keyStore = KeyStore.getInstance("PKCS12");
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("PKCS12 is a keystore type per the JLS spec", e);
        }
        try {
            byte[] content = Base64.decodeBase64((String)secretBundle.value());
            keyStore.load(new ByteArrayInputStream(content), SecretCertificateCredentials.toCharArray(this.password));
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            LogRecord lr = new LogRecord(Level.WARNING, "Credentials ID {0}: Could not load keystore from {1}");
            lr.setParameters(new Object[]{this.getId(), this.getSecretIdentifier()});
            lr.setThrown(e);
            LOGGER.log(lr);
        }
        return keyStore;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseSecretCredentials.DescriptorImpl {
        public String getDisplayName() {
            return Messages.Certificate_Credentials_Display_Name();
        }

        public FormValidation doVerifyConfiguration(@QueryParameter String servicePrincipalId, @QueryParameter String secretIdentifier, @QueryParameter Secret password) {
            KeyStore keyStore;
            SecretCertificateCredentials credentials = new SecretCertificateCredentials(CredentialsScope.SYSTEM, "", "", servicePrincipalId, secretIdentifier, password);
            try {
                keyStore = credentials.getKeyStore();
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) {
                    message = Messages.Certificate_Credentials_Validation_Invalid();
                }
                return FormValidation.error((String)message);
            }
            try {
                Enumeration<String> aliases = keyStore.aliases();
                if (!aliases.hasMoreElements()) {
                    return FormValidation.error((String)Messages.Certificate_Credentials_Validation_No_Private_Key());
                }
            }
            catch (KeyStoreException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok((String)Messages.Certificate_Credentials_Validation_OK());
        }
    }
}

