/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.keyvault;

import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.azure.keyvault.authentication.KeyVaultCredentials;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class KeyVaultClientAuthenticator
extends KeyVaultCredentials {
    private final String clientId;
    private final String clientSecret;

    public KeyVaultClientAuthenticator(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public String doAuthenticate(String authorization, String resource, String scope) {
        AuthenticationResult token = this.getAccessTokenFromClientCredentials(authorization, resource);
        return token.getAccessToken();
    }

    private AuthenticationResult getAccessTokenFromClientCredentials(String authorization, String resource) {
        AuthenticationContext context = null;
        AuthenticationResult result = null;
        ExecutorService service = null;
        try {
            service = Executors.newFixedThreadPool(1);
            context = new AuthenticationContext(authorization, false, service);
            ClientCredential credentials = new ClientCredential(this.clientId, this.clientSecret);
            Future future = context.acquireToken(resource, credentials, null);
            result = (AuthenticationResult)future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
        if (result == null) {
            throw new RuntimeException("Authentication result was null");
        }
        return result;
    }
}

