/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.util;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.microsoft.azure.util.AbstractManagedIdentitiesCredentials;
import com.microsoft.azure.util.AzureEnvUtil;
import com.microsoft.jenkins.azurecommons.core.credentials.TokenCredentialData;
import hudson.Extension;
import hudson.util.ListBoxModel;
import org.kohsuke.stapler.DataBoundConstructor;

public class AzureImdsCredentials
extends AbstractManagedIdentitiesCredentials {
    public AzureImdsCredentials(CredentialsScope scope, String id, String description) {
        super(scope, id, description);
    }

    @DataBoundConstructor
    public AzureImdsCredentials(CredentialsScope scope, String id, String description, String azureEnvName) {
        super(scope, id, description);
        this.setAzureEnvName(azureEnvName);
        this.setAzureEnvironment(AzureEnvUtil.resolveAzureEnv(azureEnvName));
    }

    @Override
    public TokenCredentialData createToken() {
        TokenCredentialData token = super.createToken();
        token.setType(2);
        return token;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Managed Identities for Azure Resources";
        }

        public ListBoxModel doFillAzureEnvNameItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Azure");
            model.add("Azure China");
            model.add("Azure Germany");
            model.add("Azure US Government");
            return model;
        }
    }
}

