/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.util;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.cloudbees.plugins.credentials.impl.CertificateCredentialsImpl;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.ApplicationTokenCredentials;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.resources.Subscription;
import com.microsoft.azure.util.AzureBaseCredentials;
import com.microsoft.azure.util.AzureEnvUtil;
import com.microsoft.azure.util.Messages;
import com.microsoft.jenkins.azurecommons.core.credentials.TokenCredentialData;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class AzureCredentials
extends AzureBaseCredentials {
    private final ServicePrincipal data;

    @DataBoundConstructor
    public AzureCredentials(CredentialsScope scope, String id, String description, String subscriptionId, String clientId, String clientSecret) {
        super(scope, id, description);
        this.data = new ServicePrincipal(subscriptionId, clientId, clientSecret);
    }

    @Deprecated
    public AzureCredentials(CredentialsScope scope, String id, String description, String subscriptionId, String clientId, String clientSecret, String oauth2TokenEndpoint, String serviceManagementURL, String authenticationEndpoint, String resourceManagerEndpoint, String graphEndpoint) {
        super(scope, id, description);
        this.data = new ServicePrincipal(subscriptionId, clientId, clientSecret);
        this.data.setTenant(ServicePrincipal.getTenantFromTokenEndpoint(oauth2TokenEndpoint));
        this.data.setManagementEndpoint(serviceManagementURL);
        this.data.setActiveDirectoryEndpoint(authenticationEndpoint);
        this.data.setResourceManagerEndpoint(resourceManagerEndpoint);
        this.data.setGraphEndpoint(graphEndpoint);
    }

    @Deprecated
    public static ServicePrincipal getServicePrincipal(String credentialsId) {
        AzureCredentials creds = (AzureCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(AzureCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (creds == null) {
            return new ServicePrincipal();
        }
        return creds.data;
    }

    public String getSubscriptionId() {
        return this.data.subscriptionId.getPlainText();
    }

    public String getClientId() {
        return this.data.clientId.getPlainText();
    }

    public String getClientSecret() {
        if (StringUtils.isEmpty((String)this.data.clientSecret.getPlainText())) {
            return "";
        }
        return this.data.clientSecret.getEncryptedValue();
    }

    public String getPlainClientSecret() {
        return this.data.clientSecret.getPlainText();
    }

    @DataBoundSetter
    public void setCertificateId(String certificateId) {
        this.data.setCertificateId(certificateId);
    }

    public String getCertificateId() {
        return this.data.getCertificateId();
    }

    public String getTenant() {
        return this.data.getTenant();
    }

    @DataBoundSetter
    public void setTenant(String tenant) {
        this.data.setTenant(tenant);
    }

    @Deprecated
    public String getOauth2TokenEndpoint() {
        return "https://login.windows.net/" + this.data.getTenant();
    }

    @DataBoundSetter
    @Deprecated
    public void setOauth2TokenEndpoint(String oauth2TokenEndpoint) {
        this.data.setOauth2TokenEndpoint(oauth2TokenEndpoint);
    }

    @Deprecated
    public String getAzureEnvionmentName() {
        return this.data.getAzureEnvironmentName();
    }

    @Override
    public String getAzureEnvironmentName() {
        return this.data.getAzureEnvironmentName();
    }

    @DataBoundSetter
    public void setAzureEnvironmentName(String azureEnvironmentName) {
        this.data.setAzureEnvironmentName(azureEnvironmentName);
    }

    @Deprecated
    public String getServiceManagementURL() {
        return this.getManagementEndpoint();
    }

    @Override
    public String getManagementEndpoint() {
        return this.data.serviceManagementURL;
    }

    @DataBoundSetter
    @Deprecated
    public void setServiceManagementURL(String serviceManagementURL) {
        this.setManagementEndpoint(serviceManagementURL);
    }

    @DataBoundSetter
    public void setManagementEndpoint(String managementEndpoint) {
        this.data.setManagementEndpoint(managementEndpoint);
    }

    @Deprecated
    public String getAuthenticationEndpoint() {
        return this.getActiveDirectoryEndpoint();
    }

    @Override
    public String getActiveDirectoryEndpoint() {
        return this.data.authenticationEndpoint;
    }

    @DataBoundSetter
    @Deprecated
    public void setAuthenticationEndpoint(String authenticationEndpoint) {
        this.setActiveDirectoryEndpoint(authenticationEndpoint);
    }

    @DataBoundSetter
    public void setActiveDirectoryEndpoint(String activeDirectoryEndpoint) {
        this.data.setActiveDirectoryEndpoint(activeDirectoryEndpoint);
    }

    @Override
    public String getResourceManagerEndpoint() {
        return this.data.resourceManagerEndpoint;
    }

    @DataBoundSetter
    public void setResourceManagerEndpoint(String resourceManagerEndpoint) {
        this.data.setResourceManagerEndpoint(resourceManagerEndpoint);
    }

    @Override
    public String getGraphEndpoint() {
        return this.data.graphEndpoint;
    }

    @Override
    public TokenCredentialData createToken() {
        TokenCredentialData token = super.createToken();
        token.setType(0);
        token.setClientId(this.getClientId());
        token.setClientSecret(this.getPlainClientSecret());
        token.setCertificateBytes(this.data.getCertificateBytes());
        token.setCertificatePassword(this.data.getCertificatePassword());
        token.setTenant(this.getTenant());
        token.setSubscriptionId(this.getSubscriptionId());
        return token;
    }

    @DataBoundSetter
    public void setGraphEndpoint(String graphEndpoint) {
        this.data.setGraphEndpoint(graphEndpoint);
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Microsoft Azure Service Principal";
        }

        public FormValidation doVerifyConfiguration(@QueryParameter String subscriptionId, @QueryParameter String clientId, @QueryParameter String clientSecret, @QueryParameter String certificateId, @QueryParameter String tenant, @QueryParameter String azureEnvironmentName, @QueryParameter String serviceManagementURL, @QueryParameter String authenticationEndpoint, @QueryParameter String resourceManagerEndpoint, @QueryParameter String graphEndpoint) {
            ServicePrincipal servicePrincipal = new ServicePrincipal(subscriptionId, clientId, clientSecret);
            servicePrincipal.setCertificateId(certificateId);
            servicePrincipal.setTenant(tenant);
            servicePrincipal.setAzureEnvironmentName(azureEnvironmentName);
            servicePrincipal.setManagementEndpoint(serviceManagementURL);
            servicePrincipal.setActiveDirectoryEndpoint(authenticationEndpoint);
            servicePrincipal.setResourceManagerEndpoint(resourceManagerEndpoint);
            servicePrincipal.setGraphEndpoint(graphEndpoint);
            try {
                servicePrincipal.validate();
            }
            catch (ValidationException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok((String)Messages.Azure_Config_Success());
        }

        public ListBoxModel doFillCertificateIdItems(@AncestorInPath Item owner) {
            StandardListBoxModel model = new StandardListBoxModel();
            model.add(Messages.Azure_Credentials_Select(), "");
            model.includeAs(ACL.SYSTEM, owner, CertificateCredentialsImpl.class);
            return model;
        }

        public ListBoxModel doFillAzureEnvironmentNameItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Azure");
            model.add("Azure China");
            model.add("Azure Germany");
            model.add("Azure US Government");
            return model;
        }
    }

    public static class ServicePrincipal
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Secret subscriptionId;
        private final Secret clientId;
        private final Secret clientSecret;
        private String certificateId;
        private Secret oauth2TokenEndpoint;
        private String serviceManagementURL;
        private Secret tenant;
        private String authenticationEndpoint;
        private String resourceManagerEndpoint;
        private String graphEndpoint;
        private String azureEnvironmentName;
        private transient AzureEnvironment azureEnvironment;
        private static final int TOKEN_ENDPOINT_URL_ENDPOINT_POSTION = 3;

        private Object readResolve() throws ObjectStreamException {
            if (StringUtils.isNotBlank((String)this.azureEnvironmentName)) {
                return this;
            }
            HashMap<String, AzureEnvironment> environmentMap = new HashMap<String, AzureEnvironment>();
            environmentMap.put("Azure", AzureEnvironment.AZURE);
            environmentMap.put("Azure China", AzureEnvironment.AZURE_CHINA);
            environmentMap.put("Azure Germany", AzureEnvironment.AZURE_GERMANY);
            environmentMap.put("Azure US Government", AzureEnvironment.AZURE_US_GOVERNMENT);
            boolean matched = false;
            for (Map.Entry entry : environmentMap.entrySet()) {
                if (!this.matchEnvironment((AzureEnvironment)entry.getValue())) continue;
                this.azureEnvironmentName = (String)entry.getKey();
                this.serviceManagementURL = null;
                this.authenticationEndpoint = null;
                this.resourceManagerEndpoint = null;
                this.graphEndpoint = null;
                matched = true;
                break;
            }
            if (!matched) {
                this.azureEnvironmentName = "Azure";
            }
            return this;
        }

        public String getSubscriptionId() {
            if (this.subscriptionId == null) {
                return "";
            }
            return this.subscriptionId.getPlainText();
        }

        public String getClientId() {
            if (this.clientId == null) {
                return "";
            }
            return this.clientId.getPlainText();
        }

        public String getClientSecret() {
            if (this.clientSecret == null) {
                return "";
            }
            return this.clientSecret.getPlainText();
        }

        public String getCertificateId() {
            return this.certificateId;
        }

        public void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Nullable
        CertificateCredentialsImpl getCertificate() {
            if (StringUtils.isNotEmpty((String)this.clientSecret.getPlainText())) {
                return null;
            }
            if (StringUtils.isEmpty((String)this.certificateId)) {
                return null;
            }
            CertificateCredentialsImpl certificate = (CertificateCredentialsImpl)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(CertificateCredentialsImpl.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.certificateId));
            return certificate;
        }

        @Nullable
        public byte[] getCertificateBytes() {
            CertificateCredentialsImpl certificate = this.getCertificate();
            if (certificate == null) {
                return null;
            }
            return certificate.getKeyStoreSource().getKeyStoreBytes();
        }

        @Nullable
        public String getCertificatePassword() {
            CertificateCredentialsImpl certificate = this.getCertificate();
            if (certificate == null) {
                return null;
            }
            return certificate.getPassword().getPlainText();
        }

        public String getTenant() {
            if (this.tenant == null || StringUtils.isBlank((String)this.tenant.getPlainText())) {
                if (this.oauth2TokenEndpoint != null) {
                    return ServicePrincipal.getTenantFromTokenEndpoint(this.oauth2TokenEndpoint.getPlainText());
                }
                return ServicePrincipal.getTenantFromTokenEndpoint("");
            }
            return this.tenant.getPlainText();
        }

        public String getAzureEnvironmentName() {
            return this.azureEnvironmentName;
        }

        public AzureEnvironment getAzureEnvironment() {
            if (this.azureEnvironment != null) {
                return this.azureEnvironment;
            }
            String envName = this.getAzureEnvironmentName();
            this.azureEnvironment = AzureEnvUtil.resolveAzureEnv(envName);
            AzureEnvUtil.resolveOverride(this.azureEnvironment, AzureEnvironment.Endpoint.MANAGEMENT, this.serviceManagementURL);
            AzureEnvUtil.resolveOverride(this.azureEnvironment, AzureEnvironment.Endpoint.ACTIVE_DIRECTORY, this.authenticationEndpoint);
            AzureEnvUtil.resolveOverride(this.azureEnvironment, AzureEnvironment.Endpoint.RESOURCE_MANAGER, this.resourceManagerEndpoint);
            AzureEnvUtil.resolveOverride(this.azureEnvironment, AzureEnvironment.Endpoint.GRAPH, this.graphEndpoint);
            return this.azureEnvironment;
        }

        @Deprecated
        public String getServiceManagementURL() {
            return this.getManagementEndpoint();
        }

        public String getManagementEndpoint() {
            AzureEnvironment env = this.getAzureEnvironment();
            return env.managementEndpoint();
        }

        @Deprecated
        public String getAuthenticationEndpoint() {
            return this.getActiveDirectoryEndpoint();
        }

        public String getActiveDirectoryEndpoint() {
            AzureEnvironment env = this.getAzureEnvironment();
            return env.activeDirectoryEndpoint();
        }

        public String getResourceManagerEndpoint() {
            AzureEnvironment env = this.getAzureEnvironment();
            return env.resourceManagerEndpoint();
        }

        public String getGraphEndpoint() {
            AzureEnvironment env = this.getAzureEnvironment();
            return env.graphEndpoint();
        }

        @Deprecated
        void setOauth2TokenEndpoint(String oauth2TokenEndpoint) {
            this.oauth2TokenEndpoint = null;
            if (StringUtils.isNotBlank((String)oauth2TokenEndpoint)) {
                this.tenant = Secret.fromString((String)ServicePrincipal.getTenantFromTokenEndpoint(oauth2TokenEndpoint));
            }
        }

        void setTenant(String tenant) {
            this.tenant = Secret.fromString((String)tenant);
            if (StringUtils.isNotBlank((String)this.tenant.getPlainText())) {
                this.oauth2TokenEndpoint = null;
            }
        }

        void setManagementEndpoint(String managementEndpoint) {
            this.serviceManagementURL = StringUtils.trimToNull((String)managementEndpoint);
            this.azureEnvironment = null;
        }

        void setActiveDirectoryEndpoint(String activeDirectoryEndpoint) {
            this.authenticationEndpoint = StringUtils.trimToNull((String)activeDirectoryEndpoint);
            this.azureEnvironment = null;
        }

        void setResourceManagerEndpoint(String resourceManagerEndpoint) {
            this.resourceManagerEndpoint = StringUtils.trimToNull((String)resourceManagerEndpoint);
            this.azureEnvironment = null;
        }

        void setGraphEndpoint(String graphEndpoint) {
            this.graphEndpoint = StringUtils.trimToNull((String)graphEndpoint);
            this.azureEnvironment = null;
        }

        void setAzureEnvironmentName(String azureEnvironmentName) {
            this.azureEnvironmentName = azureEnvironmentName;
            this.azureEnvironment = null;
        }

        private boolean matchEnvironment(AzureEnvironment env) {
            return !AzureEnvUtil.isOverridden(env.managementEndpoint(), this.serviceManagementURL) && !AzureEnvUtil.isOverridden(env.resourceManagerEndpoint(), this.resourceManagerEndpoint) && !AzureEnvUtil.isOverridden(env.activeDirectoryEndpoint(), this.authenticationEndpoint) && !AzureEnvUtil.isOverridden(env.graphEndpoint(), this.graphEndpoint);
        }

        public ServicePrincipal(String subscriptionId, String clientId, String clientSecret) {
            this.subscriptionId = Secret.fromString((String)subscriptionId);
            this.clientId = Secret.fromString((String)clientId);
            this.clientSecret = Secret.fromString((String)clientSecret);
            this.tenant = Secret.fromString((String)"");
        }

        @Deprecated
        public ServicePrincipal(String subscriptionId, String clientId, String clientSecret, String oauth2TokenEndpoint, String serviceManagementURL, String authenticationEndpoint, String resourceManagerEndpoint, String graphEndpoint) {
            this.subscriptionId = Secret.fromString((String)subscriptionId);
            this.clientId = Secret.fromString((String)clientId);
            this.clientSecret = Secret.fromString((String)clientSecret);
            this.tenant = Secret.fromString((String)ServicePrincipal.getTenantFromTokenEndpoint(oauth2TokenEndpoint));
            this.serviceManagementURL = StringUtils.trimToNull((String)serviceManagementURL);
            this.authenticationEndpoint = StringUtils.trimToNull((String)authenticationEndpoint);
            this.resourceManagerEndpoint = StringUtils.trimToNull((String)resourceManagerEndpoint);
            this.graphEndpoint = StringUtils.trimToNull((String)graphEndpoint);
        }

        public ServicePrincipal() {
            this.subscriptionId = Secret.fromString((String)"");
            this.clientId = Secret.fromString((String)"");
            this.clientSecret = Secret.fromString((String)"");
            this.tenant = Secret.fromString((String)"");
        }

        public boolean isBlank() {
            return StringUtils.isBlank((String)this.subscriptionId.getPlainText()) || StringUtils.isBlank((String)this.clientId.getPlainText()) || StringUtils.isBlank((String)this.getTenant()) || StringUtils.isBlank((String)this.clientSecret.getPlainText());
        }

        public boolean validate() throws ValidationException {
            if (StringUtils.isBlank((String)this.subscriptionId.getPlainText())) {
                throw new ValidationException(Messages.Azure_SubscriptionID_Missing());
            }
            if (StringUtils.isBlank((String)this.clientId.getPlainText())) {
                throw new ValidationException(Messages.Azure_ClientID_Missing());
            }
            String secret = this.clientSecret.getPlainText();
            if (StringUtils.isEmpty((String)secret) && StringUtils.isBlank((String)this.certificateId)) {
                throw new ValidationException(Messages.Azure_ClientSecret_Missing());
            }
            if (StringUtils.isBlank((String)this.getTenant())) {
                throw new ValidationException(Messages.Azure_OAuthToken_Malformed());
            }
            try {
                Azure.Authenticated auth;
                String credentialSubscriptionId = this.getSubscriptionId();
                if (StringUtils.isEmpty((String)secret)) {
                    CertificateCredentialsImpl certificate = this.getCertificate();
                    if (certificate == null) {
                        throw new ValidationException(Messages.Azure_ClientCertificate_NotFound());
                    }
                    byte[] certificateBytes = certificate.getKeyStoreSource().getKeyStoreBytes();
                    auth = Azure.authenticate((AzureTokenCredentials)new ApplicationTokenCredentials(this.getClientId(), this.getTenant(), certificateBytes, certificate.getPassword().getPlainText(), this.getAzureEnvironment()));
                } else {
                    auth = Azure.authenticate((AzureTokenCredentials)new ApplicationTokenCredentials(this.getClientId(), this.getTenant(), this.getClientSecret(), this.getAzureEnvironment()));
                }
                for (Subscription subscription : auth.subscriptions().list()) {
                    if (!subscription.subscriptionId().equalsIgnoreCase(credentialSubscriptionId)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                throw new ValidationException(Messages.Azure_CantValidate());
            }
            throw new ValidationException(Messages.Azure_Invalid_SubscriptionId());
        }

        private static String getTenantFromTokenEndpoint(String oauth2TokenEndpoint) {
            if (!oauth2TokenEndpoint.matches("https{0,1}://[a-zA-Z0-9\\.]*/[a-z0-9\\-]*/?.*$")) {
                return "";
            }
            String[] parts = oauth2TokenEndpoint.split("/");
            if (parts.length < 4) {
                return "";
            }
            return parts[3];
        }
    }

    public static class ValidationException
    extends Exception {
        public ValidationException(String message) {
            super(message);
        }
    }
}

