/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.util;

import com.cloudbees.plugins.credentials.BaseCredentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.microsoft.azure.util.AzureBaseCredentials;
import com.microsoft.azure.util.AzureCredentials;
import com.microsoft.azure.util.AzureImdsCredentials;
import com.microsoft.azure.util.AzureMsiCredentials;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.util.Collections;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

public final class AzureCredentialUtil {
    private AzureCredentialUtil() {
    }

    public static AzureBaseCredentials getCredential(@Nullable Item owner, String credentialId) {
        return (AzureBaseCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(AzureBaseCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
    }

    public static String getManagementEndpoint(@Nullable Item owner, String credentialId) {
        AzureBaseCredentials credential = AzureCredentialUtil.getCredential(owner, credentialId);
        if (credential != null) {
            return credential.getManagementEndpoint();
        }
        return null;
    }

    @Deprecated
    public static BaseCredentials getCredential(String credentialId) {
        BaseCredentials credential = (BaseCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(AzureMsiCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
        if (credential != null) {
            return credential;
        }
        credential = (BaseCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(AzureImdsCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
        if (credential != null) {
            return credential;
        }
        credential = (BaseCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(AzureCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
        return credential;
    }

    @Deprecated
    public static AzureBaseCredentials getCredential2(String credentialId) {
        return AzureCredentialUtil.getCredential(null, credentialId);
    }

    @Deprecated
    public static String getManagementEndpoint(String credentialId) {
        return AzureCredentialUtil.getManagementEndpoint(null, credentialId);
    }
}

