/*
 * Decompiled with CFR 0.152.
 */
package wirelabs.commons;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import wirelabs.commons.ExpirableCacheRepopulator;

public class ExpirableCache<T>
implements Serializable {
    private static final long serialVersionUID = 4974308528003877624L;
    private ConcurrentHashMap<String, Long> expirationTime = new ConcurrentHashMap();
    private ConcurrentHashMap<String, T> data = new ConcurrentHashMap();
    private long ttl;

    public ExpirableCache(long ttl) {
        this.ttl = ttl;
    }

    public T put(String key, T value) {
        return this.put(key, value, this.ttl);
    }

    public T put(String key, T value, long ttl) {
        long expiration = System.currentTimeMillis() + ttl;
        this.expirationTime.put(key, expiration);
        return this.data.put(key, value);
    }

    public T get(String key, ExpirableCacheRepopulator<T> populate) {
        return this.get(key, this.ttl, populate);
    }

    public T get(String key, long ttl, ExpirableCacheRepopulator<T> populate) {
        T result = this.data.get(key);
        if (result == null || this.expirationTime.get(key) < System.currentTimeMillis()) {
            try {
                result = populate.call(result);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.put(key, result, ttl);
        }
        return result;
    }
}

