/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.autocompleteparameter.providers;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.jenkinsci.plugins.autocompleteparameter.GlobalVariableUtils;
import org.jenkinsci.plugins.autocompleteparameter.JSONUtils;
import org.jenkinsci.plugins.autocompleteparameter.providers.AutocompleteDataProvider;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;
import wirelabs.commons.RequestBuilder;

public class RemoteDataProvider
extends AutocompleteDataProvider {
    private static final long serialVersionUID = 5773462762109544336L;
    private boolean prefetch;
    private String autoCompleteUrl;
    private String credentialsId;

    @DataBoundConstructor
    public RemoteDataProvider(boolean prefetch, String autoCompleteUrl, String credentialsId) {
        this.prefetch = prefetch;
        this.autoCompleteUrl = autoCompleteUrl;
        this.credentialsId = credentialsId;
    }

    @Override
    public Collection<?> getData() {
        return JSONUtils.toCanonicalCollection(RemoteDataProvider.performRequest(this.autoCompleteUrl, this.credentialsId));
    }

    @Override
    public Collection<?> filter(String query) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        try {
            parameters.put("query", URLEncoder.encode(query, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String replaced = StrSubstitutor.replace((Object)this.autoCompleteUrl, parameters);
        if (this.autoCompleteUrl.equals(replaced)) {
            replaced = this.autoCompleteUrl + query;
        }
        return JSONUtils.toCanonicalCollection(RemoteDataProvider.performRequest(replaced, this.credentialsId));
    }

    @Override
    public boolean isPrefetch() {
        return this.prefetch;
    }

    @Exported
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Exported
    public String getAutoCompleteUrl() {
        return this.autoCompleteUrl;
    }

    private static String performRequest(String uri, String credentialsId) {
        return RequestBuilder.url((String)GlobalVariableUtils.resolveVariables((String)uri)).cache().header((String)"Accept", (String)"*/*").credentials((String)credentialsId).get().content;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AutocompleteDataProvider> {
        public String getDisplayName() {
            return "Remote request";
        }

        public FormValidation doCheckAutoCompleteUrl(@QueryParameter boolean prefetch, @QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)"Invalid URL");
            }
            try {
                new URL(GlobalVariableUtils.resolveVariables(value));
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)("Invalid URL: " + e.getMessage()));
            }
            if (!prefetch && !value.contains("${query}")) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)"<div class=\"observation\">Optional: You may add ${query} to url and it will replace with typed text.<br/>e.g.: http://remote/search?q=${query}<br/>e.g.: http://remote/search/${query}.json</div>");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String credentialsId) {
            return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, context, StandardUsernamePasswordCredentials.class).includeCurrentValue(credentialsId);
        }
    }
}

