/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.autocompleteparameter.providers;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.NotImplementedException;
import org.jenkinsci.plugins.autocompleteparameter.JSONUtils;
import org.jenkinsci.plugins.autocompleteparameter.providers.AutocompleteDataProvider;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class InlineJsonDataProvider
extends AutocompleteDataProvider {
    private static final long serialVersionUID = 5282725458728513422L;
    private String autoCompleteData;

    @DataBoundConstructor
    public InlineJsonDataProvider(String autoCompleteData) {
        this.autoCompleteData = autoCompleteData;
    }

    @Override
    public Collection<?> getData() {
        if (this.autoCompleteData == null) {
            return Collections.emptyList();
        }
        return JSONUtils.toCanonicalCollection(this.autoCompleteData);
    }

    public String getAutoCompleteData() {
        return this.autoCompleteData;
    }

    public void setAutoCompleteData(String autoCompleteData) {
        this.autoCompleteData = autoCompleteData;
    }

    @Override
    public Collection<?> filter(String query) {
        throw new NotImplementedException("Filter not implemented for " + this.getClass().getSimpleName());
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AutocompleteDataProvider> {
        public String getDisplayName() {
            return "Inline Json Array";
        }

        public FormValidation doCheckAutoCompleteData(@QueryParameter String autoCompleteData) {
            try {
                JSONUtils.toCanonicalCollection(autoCompleteData);
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

