/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.autocompleteparameter.providers;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jenkinsci.plugins.autocompleteparameter.SafeJenkins;

public abstract class AutocompleteDataProvider
implements Describable<AutocompleteDataProvider>,
ExtensionPoint,
Serializable {
    private static final transient ExecutorService executor = Executors.newCachedThreadPool();

    protected static <T> T executeWithTimeout(Callable<T> callable, long timeout, TimeUnit unit) throws Exception {
        Future<T> task = executor.submit(callable);
        try {
            return task.get(timeout, unit);
        }
        catch (TimeoutException ex) {
            throw new TimeoutException("Failed to execute within time limit: " + timeout + " " + unit.name());
        }
        catch (ExecutionException ex) {
            throw (Exception)ex.getCause();
        }
    }

    public abstract Collection<?> getData();

    public Collection<?> getData(long timeout, TimeUnit unit) throws Exception {
        Callable callable = new Callable<Collection<?>>(){

            @Override
            public Collection<?> call() throws Exception {
                return AutocompleteDataProvider.this.getData();
            }
        };
        return (Collection)AutocompleteDataProvider.executeWithTimeout(callable, timeout, unit);
    }

    public boolean isPrefetch() {
        return true;
    }

    public abstract Collection<?> filter(String var1);

    public Collection<?> filter(final String query, long timeout, TimeUnit unit) throws Exception {
        Callable callable = new Callable<Collection<?>>(){

            @Override
            public Collection<?> call() throws Exception {
                return AutocompleteDataProvider.this.filter(query);
            }
        };
        return (Collection)AutocompleteDataProvider.executeWithTimeout(callable, timeout, unit);
    }

    public static DescriptorExtensionList<AutocompleteDataProvider, Descriptor<AutocompleteDataProvider>> all() {
        return SafeJenkins.getInstanceOrCry().getDescriptorList(AutocompleteDataProvider.class);
    }

    public Descriptor<AutocompleteDataProvider> getDescriptor() {
        return SafeJenkins.getInstanceOrCry().getDescriptorOrDie(this.getClass());
    }
}

