/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.autocompleteparameter;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterValue;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.autocompleteparameter.JSONUtils;
import org.jenkinsci.plugins.autocompleteparameter.Utils;
import org.jenkinsci.plugins.autocompleteparameter.providers.AutocompleteDataProvider;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.export.Exported;

public class DropdownAutocompleteParameterDefinition
extends SimpleParameterDefinition {
    private AutocompleteDataProvider dataProvider;
    private String displayExpression;
    private String valueExpression;
    private String defaultValue;

    @DataBoundConstructor
    public DropdownAutocompleteParameterDefinition(String name, String description, String displayExpression, String valueExpression, String defaultValue, AutocompleteDataProvider dataProvider) {
        super(name, description);
        this.displayExpression = displayExpression;
        this.valueExpression = valueExpression;
        this.defaultValue = defaultValue;
        this.dataProvider = dataProvider;
    }

    public AutocompleteDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(AutocompleteDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Exported
    public String getDisplayExpression() {
        return this.displayExpression;
    }

    @Exported
    public String getValueExpression() {
        return this.valueExpression;
    }

    @Exported
    public String getDisplayExpressionJsSafe() {
        return Utils.normalizeExpression(this.displayExpression);
    }

    @Exported
    public String getValueExpressionJsSafe() {
        return Utils.normalizeExpression(this.valueExpression);
    }

    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
    }

    @Exported
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Exported
    public String getAutoCompleteValuesScript() {
        if (this.isPrefetch()) {
            try {
                return JSONUtils.toJSON(this.dataProvider.getData(2L, TimeUnit.MINUTES));
            }
            catch (Exception e) {
                return "'ERROR: Autocomplete data generation failure: " + e.getMessage() + "'";
            }
        }
        return "[]";
    }

    @Exported
    public boolean isPrefetch() {
        return this.dataProvider.isPrefetch();
    }

    @JavaScriptMethod
    public String filterAutoCompleteValues(String query) {
        try {
            return JSONUtils.toJSON(this.dataProvider.filter(query, 30L, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            return "'ERROR: Dropdown data generation failure: " + e.getMessage() + "'";
        }
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        StringParameterValue value = (StringParameterValue)req.bindJSON(StringParameterValue.class, jo);
        value.setDescription(this.getDescription());
        return value;
    }

    public ParameterValue createValue(String value) {
        return new StringParameterValue(this.getName(), value, this.getDescription());
    }

    @Extension
    public static final class DescriptImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Dropdown Autocomplete Parameter";
        }

        public List<Descriptor<AutocompleteDataProvider>> getDataProviders() {
            return AutocompleteDataProvider.all();
        }
    }
}

