/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.autocompleteparameter;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.StringParameterDefinition;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.autocompleteparameter.JSONUtils;
import org.jenkinsci.plugins.autocompleteparameter.Utils;
import org.jenkinsci.plugins.autocompleteparameter.providers.AutocompleteDataProvider;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.export.Exported;

public class AutoCompleteStringParameterDefinition
extends StringParameterDefinition {
    private static final long serialVersionUID = 2691768740499486855L;
    private String displayExpression;
    private String valueExpression;
    private AutocompleteDataProvider dataProvider;
    private boolean allowUnrecognizedTokens;

    @DataBoundConstructor
    public AutoCompleteStringParameterDefinition(String name, String defaultValue, String description, String displayExpression, String valueExpression, boolean allowUnrecognizedTokens, AutocompleteDataProvider dataProvider) {
        super(name, defaultValue, description);
        this.valueExpression = valueExpression;
        this.displayExpression = displayExpression;
        this.allowUnrecognizedTokens = allowUnrecognizedTokens;
        this.dataProvider = dataProvider;
    }

    public ParameterValue createValue(String value) {
        return super.createValue(value);
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        return super.createValue(req, jo);
    }

    public AutocompleteDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(AutocompleteDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Exported
    public String getDisplayExpression() {
        return this.displayExpression;
    }

    @Exported
    public void setDisplayExpression(String labelField) {
        this.displayExpression = labelField;
    }

    @Exported
    public String getValueExpression() {
        return this.valueExpression;
    }

    @Exported
    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
    }

    @Exported
    public String getDisplayExpressionJsSafe() {
        return Utils.normalizeExpression(this.displayExpression);
    }

    @Exported
    public String getValueExpressionJsSafe() {
        return Utils.normalizeExpression(this.valueExpression);
    }

    @Exported
    public String getAutoCompleteValuesScript() {
        if (this.isPrefetch()) {
            try {
                return JSONUtils.toJSON(this.dataProvider.getData(2L, TimeUnit.MINUTES));
            }
            catch (Exception e) {
                return "'ERROR: Autocomplete data generation failure: " + e.getMessage() + "'";
            }
        }
        return "[]";
    }

    @Exported
    public boolean isPrefetch() {
        return this.dataProvider.isPrefetch();
    }

    @JavaScriptMethod
    public String filterAutoCompleteValues(String query) {
        try {
            return JSONUtils.toJSON(this.dataProvider.filter(query, 30L, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            return "'ERROR: Autocomplete data generation failure: " + e.getMessage() + "'";
        }
    }

    public boolean isAllowUnrecognizedTokens() {
        return this.allowUnrecognizedTokens;
    }

    public void setAllowUnrecognizedTokens(boolean allowUnrecognizedTokens) {
        this.allowUnrecognizedTokens = allowUnrecognizedTokens;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Extension
    public static final class DescriptImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Auto Complete String Parameter";
        }

        public List<Descriptor<AutocompleteDataProvider>> getDataProviders() {
            return AutocompleteDataProvider.all();
        }
    }
}

