/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.authorizeproject;

import hudson.model.Describable;
import hudson.model.Descriptor;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class AuthorizeProjectUtil {
    public static <T extends Describable<?>> T bindJSONWithDescriptor(StaplerRequest req, JSONObject formData, String fieldName, Class<T> clazz) throws Descriptor.FormException {
        if ((formData = formData.getJSONObject(fieldName)) == null || formData.isNullObject()) {
            return null;
        }
        String staplerClazzName = formData.optString("$class", null);
        if (staplerClazzName == null) {
            staplerClazzName = formData.optString("stapler-class", null);
        }
        if (staplerClazzName == null) {
            throw new Descriptor.FormException("No $class is specified", fieldName);
        }
        try {
            Class<?> staplerClass = Jenkins.get().getPluginManager().uberClassLoader.loadClass(staplerClazzName);
            Descriptor d = Jenkins.get().getDescriptorOrDie(staplerClass);
            Describable instance = d.newInstance(req, formData);
            return (T)instance;
        }
        catch (ClassNotFoundException e) {
            throw new Descriptor.FormException(String.format("Failed to instantiate %s", staplerClazzName), (Throwable)e, fieldName);
        }
    }

    public static boolean userIdEquals(@CheckForNull String a, @CheckForNull String b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return Jenkins.get().getSecurityRealm().getUserIdStrategy().equals(a, b);
    }
}

