/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.authorizeproject;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategyDescriptor;
import org.jenkinsci.plugins.authorizeproject.Messages;
import org.jenkinsci.plugins.authorizeproject.ProjectQueueItemAuthenticator;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class AuthorizeProjectStrategy
extends AbstractDescribableImpl<AuthorizeProjectStrategy>
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(AuthorizeProjectStrategy.class.getName());

    public static DescriptorExtensionList<AuthorizeProjectStrategy, Descriptor<AuthorizeProjectStrategy>> all() {
        return Jenkins.get().getDescriptorList(AuthorizeProjectStrategy.class);
    }

    public Authentication authenticate(Job<?, ?> project, Queue.Item item) {
        if (!Util.isOverridden(AuthorizeProjectStrategy.class, ((Object)((Object)this)).getClass(), (String)"authenticate", (Class[])new Class[]{AbstractProject.class, Queue.Item.class})) {
            throw new AbstractMethodError();
        }
        if (!(project instanceof AbstractProject)) {
            Descriptor d = Jenkins.get().getDescriptor(((Object)((Object)this)).getClass());
            LOGGER.log(Level.WARNING, "This authorization strategy ({0}) is designed for authorize-project < 1.1.0 and not applicable for non-AbstractProjects (like WorkflowJob). ignored.", d != null ? d.getDisplayName() : ((Object)((Object)this)).getClass().getName());
            return null;
        }
        return this.authenticate((AbstractProject)project, item);
    }

    @Deprecated
    public Authentication authenticate(AbstractProject<?, ?> project, Queue.Item item) {
        return this.authenticate((Job<?, ?>)project, item);
    }

    public AuthorizeProjectStrategyDescriptor getDescriptor() {
        return (AuthorizeProjectStrategyDescriptor)super.getDescriptor();
    }

    public final void checkJobConfigurePermission(AccessControlled context) {
        if (!this.hasJobConfigurePermission(context)) {
            throw new AccessDeniedException(Messages.AuthorizeProjectStrategy_UserNotAuthorizedForJob(Jenkins.getAuthentication().getName()));
        }
    }

    public boolean hasJobConfigurePermission(AccessControlled context) {
        return true;
    }

    public final void checkAuthorizationConfigurePermission(AccessControlled context) {
        if (!this.hasAuthorizationConfigurePermission(context)) {
            throw new AccessDeniedException(Messages.AuthorizeProjectStrategy_UserNotAuthorized(Jenkins.getAuthentication().getName()));
        }
    }

    public boolean hasAuthorizationConfigurePermission(AccessControlled context) {
        return true;
    }

    protected Object readResolve() throws ObjectStreamException {
        this.checkUnsecuredConfiguration();
        return this;
    }

    private void checkUnsecuredConfiguration() throws ObjectStreamException {
        AccessControlled context;
        Authentication authentication = Jenkins.getAuthentication();
        if (authentication == ACL.SYSTEM) {
            return;
        }
        if (!ProjectQueueItemAuthenticator.isConfigured()) {
            return;
        }
        if (Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return;
        }
        StaplerRequest request = Stapler.getCurrentRequest();
        AccessControlled accessControlled = context = request != null ? (AccessControlled)request.findAncestorObject(AccessControlled.class) : null;
        if (context == null) {
            context = Jenkins.get();
        }
        try {
            this.checkJobConfigurePermission(context);
        }
        catch (AccessDeniedException e) {
            throw new InvalidObjectException(e.getMessage());
        }
        try {
            this.checkAuthorizationConfigurePermission(context);
        }
        catch (AccessDeniedException e) {
            throw new InvalidObjectException(e.getMessage());
        }
    }
}

