/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.assembla;

import hudson.Functions;
import hudson.Plugin;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.plugin.assembla.AssemblaSCMListener;

public class AssemblaPlugin
extends Plugin {
    public static final String NAME = "assembla";
    private transient AssemblaSCMListener scmListener;

    public void start() throws Exception {
        this.scmListener = new AssemblaSCMListener();
        this.scmListener.register();
        super.start();
    }

    public void stop() throws Exception {
        this.scmListener.unregister();
        super.stop();
    }

    public static int getTicketNumber(String group) {
        Matcher numberMatcher = Pattern.compile("[0-9]+").matcher(group);
        if (!numberMatcher.find()) {
            throw new NumberFormatException("Cannot find any valid ticket number in sequence '" + group + "'");
        }
        return Integer.parseInt(numberMatcher.group());
    }

    public static String getResourcePath(String resourceFileName) {
        if (resourceFileName.startsWith("/")) {
            resourceFileName = resourceFileName.substring(1);
        }
        String assemblaLogoUrl = String.format("%s/plugin/assembla/%s", Functions.getResourcePath(), resourceFileName);
        return assemblaLogoUrl;
    }
}

