/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.assembla;

import com.google.gson.annotations.SerializedName;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WebhookPayload {
    private static final Pattern mergeRequestIdPattern = Pattern.compile("Merge Request (\\d+)");
    private static final Pattern wikiNamePattern = Pattern.compile("^[a-z0-9-/@:\\_-]+\\.assembla\\.com[:/](?:svn/)?(?:[a-z0-9\\_-]+[/^])?([a-z0-9\\_-]+).*$", 2);
    private static final Logger LOGGER = Logger.getLogger(WebhookPayload.class.getName());
    private String space;
    private String action;
    private String object;
    private String title;
    private String body;
    private String author;
    private String branch;
    @SerializedName(value="repository_url")
    private String repositoryUrl;
    @SerializedName(value="commit_id")
    private String commitId;

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public WebhookPayload(String space, String action, String object, String title, String body, String author, String branch, String repositoryUrl, String commitId) {
        this.space = space;
        this.action = action;
        this.object = object;
        this.title = title;
        this.body = body;
        this.author = author;
        this.branch = branch;
        this.repositoryUrl = repositoryUrl;
        this.commitId = commitId;
    }

    public String getSpaceName() {
        return this.space;
    }

    public String getSpaceWikiName() {
        Matcher m = wikiNamePattern.matcher(this.repositoryUrl);
        String wikiName = "";
        try {
            if (m.matches()) {
                LOGGER.info(m.group(1));
                wikiName = m.group(1);
            }
        }
        catch (IllegalStateException | NumberFormatException ex) {
            LOGGER.log(Level.SEVERE, "Failed to parse space wiki name", ex);
        }
        return wikiName;
    }

    public String getAction() {
        return this.action;
    }

    public String getObject() {
        return this.object;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public Integer getMergeRequestId() {
        Matcher m = mergeRequestIdPattern.matcher(this.title);
        Integer mergeRequestId = null;
        try {
            if (m.find()) {
                mergeRequestId = Integer.parseInt(m.group(1));
            }
        }
        catch (IllegalStateException | NumberFormatException ex) {
            LOGGER.log(Level.SEVERE, "Failed to parse merge request ID", ex);
        }
        return mergeRequestId;
    }

    public boolean isMergeRequestEvent() {
        return this.object.equals("Merge request");
    }

    public boolean isChangesetEvent() {
        return this.object.equals("Changeset");
    }

    public boolean shouldTriggerBuild() {
        return this.isChangesetEvent() || this.isMergeRequestEvent();
    }

    public String toString() {
        return "WebhookPayload{space='" + this.space + '\'' + ", action='" + this.action + '\'' + ", object='" + this.object + '\'' + ", title='" + this.title + '\'' + ", body='" + this.body + '\'' + ", author='" + this.author + '\'' + ", branch='" + this.branch + '\'' + ", commitId='" + this.commitId + '\'' + '}';
    }
}

